/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpChannel;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpReceiver;
import com.facebook.presto.jdbc.internal.jetty.client.HttpSender;
import com.facebook.presto.jdbc.internal.jetty.client.api.Result;
import com.facebook.presto.jdbc.internal.jetty.http2.ErrorCode;
import com.facebook.presto.jdbc.internal.jetty.http2.HTTP2Stream;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Session;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Stream;
import com.facebook.presto.jdbc.internal.jetty.http2.client.http.HttpConnectionOverHTTP2;
import com.facebook.presto.jdbc.internal.jetty.http2.client.http.HttpReceiverOverHTTP2;
import com.facebook.presto.jdbc.internal.jetty.http2.client.http.HttpSenderOverHTTP2;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.ResetFrame;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;

public class HttpChannelOverHTTP2
extends HttpChannel {
    private final HttpConnectionOverHTTP2 connection;
    private final Session session;
    private final HttpSenderOverHTTP2 sender;
    private final HttpReceiverOverHTTP2 receiver;
    private Stream stream;

    public HttpChannelOverHTTP2(HttpDestination destination, HttpConnectionOverHTTP2 connection, Session session) {
        super(destination);
        this.connection = connection;
        this.session = session;
        this.sender = new HttpSenderOverHTTP2(this);
        this.receiver = new HttpReceiverOverHTTP2(this);
    }

    public Session getSession() {
        return this.session;
    }

    public Stream.Listener getStreamListener() {
        return this.receiver;
    }

    @Override
    protected HttpSender getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
        this.getHttpExchange().getRequest().attribute(HTTP2Stream.class.getName(), stream);
    }

    @Override
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    @Override
    public void release() {
        this.connection.release(this);
    }

    @Override
    public boolean abort(HttpExchange exchange, Throwable requestFailure, Throwable responseFailure) {
        Stream stream;
        boolean aborted = super.abort(exchange, requestFailure, responseFailure);
        if (aborted && (stream = this.getStream()) != null) {
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
        return aborted;
    }

    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        this.release();
    }
}

