/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http2.client;

import com.facebook.presto.jdbc.internal.jetty.http2.FlowControlStrategy;
import com.facebook.presto.jdbc.internal.jetty.http2.HTTP2Connection;
import com.facebook.presto.jdbc.internal.jetty.http2.ISession;
import com.facebook.presto.jdbc.internal.jetty.http2.api.Session;
import com.facebook.presto.jdbc.internal.jetty.http2.client.HTTP2Client;
import com.facebook.presto.jdbc.internal.jetty.http2.client.HTTP2ClientSession;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.PrefaceFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.SettingsFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.frames.WindowUpdateFrame;
import com.facebook.presto.jdbc.internal.jetty.http2.generator.Generator;
import com.facebook.presto.jdbc.internal.jetty.http2.parser.Parser;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.Connection;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.component.LifeCycle;
import com.facebook.presto.jdbc.internal.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;

public class HTTP2ClientConnectionFactory
implements ClientConnectionFactory {
    public static final String CLIENT_CONTEXT_KEY = "http2.client";
    public static final String BYTE_BUFFER_POOL_CONTEXT_KEY = "http2.client.byteBufferPool";
    public static final String EXECUTOR_CONTEXT_KEY = "http2.client.executor";
    public static final String SCHEDULER_CONTEXT_KEY = "http2.client.scheduler";
    public static final String SESSION_LISTENER_CONTEXT_KEY = "http2.client.sessionListener";
    public static final String SESSION_PROMISE_CONTEXT_KEY = "http2.client.sessionPromise";
    private final Connection.Listener connectionListener = new ConnectionListener();
    private int initialSessionRecvWindow = 65535;

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HTTP2Client client = (HTTP2Client)context.get(CLIENT_CONTEXT_KEY);
        ByteBufferPool byteBufferPool = (ByteBufferPool)context.get(BYTE_BUFFER_POOL_CONTEXT_KEY);
        Executor executor = (Executor)context.get(EXECUTOR_CONTEXT_KEY);
        Scheduler scheduler = (Scheduler)context.get(SCHEDULER_CONTEXT_KEY);
        Session.Listener listener = (Session.Listener)context.get(SESSION_LISTENER_CONTEXT_KEY);
        Promise promise = (Promise)context.get(SESSION_PROMISE_CONTEXT_KEY);
        Generator generator = new Generator(byteBufferPool);
        FlowControlStrategy flowControl = this.newFlowControlStrategy();
        if (flowControl == null) {
            flowControl = client.getFlowControlStrategyFactory().newFlowControlStrategy();
        }
        HTTP2ClientSession session = new HTTP2ClientSession(scheduler, endPoint, generator, listener, flowControl);
        Parser parser = new Parser(byteBufferPool, session, 4096, 8192);
        HTTP2ClientConnection connection = new HTTP2ClientConnection(client, byteBufferPool, executor, endPoint, parser, session, client.getInputBufferSize(), promise, listener);
        connection.addListener(this.connectionListener);
        return connection;
    }

    @Deprecated
    protected FlowControlStrategy newFlowControlStrategy() {
        return null;
    }

    @Deprecated
    public int getInitialSessionRecvWindow() {
        return this.initialSessionRecvWindow;
    }

    @Deprecated
    public void setInitialSessionRecvWindow(int initialSessionRecvWindow) {
        this.initialSessionRecvWindow = initialSessionRecvWindow;
    }

    private class ConnectionListener
    implements Connection.Listener {
        private ConnectionListener() {
        }

        @Override
        public void onOpened(Connection connection) {
            HTTP2ClientConnection http2Connection = (HTTP2ClientConnection)connection;
            http2Connection.client.addManaged((LifeCycle)((Object)http2Connection.getSession()));
        }

        @Override
        public void onClosed(Connection connection) {
            HTTP2ClientConnection http2Connection = (HTTP2ClientConnection)connection;
            http2Connection.client.removeBean(http2Connection.getSession());
        }
    }

    private class HTTP2ClientConnection
    extends HTTP2Connection
    implements Callback {
        private final HTTP2Client client;
        private final Promise<Session> promise;
        private final Session.Listener listener;

        public HTTP2ClientConnection(HTTP2Client client, ByteBufferPool byteBufferPool, Executor executor, EndPoint endpoint, Parser parser, ISession session, int bufferSize, Promise<Session> promise, Session.Listener listener) {
            super(byteBufferPool, executor, endpoint, parser, session, bufferSize);
            this.client = client;
            this.promise = promise;
            this.listener = listener;
        }

        @Override
        public void onOpen() {
            int windowDelta;
            Map<Integer, Integer> settings = this.listener.onPreface(this.getSession());
            if (settings == null) {
                settings = Collections.emptyMap();
            }
            PrefaceFrame prefaceFrame = new PrefaceFrame();
            SettingsFrame settingsFrame = new SettingsFrame(settings, false);
            ISession session = this.getSession();
            int sessionRecv = this.client.getInitialSessionRecvWindow();
            if (sessionRecv == 65535) {
                sessionRecv = HTTP2ClientConnectionFactory.this.initialSessionRecvWindow;
            }
            if ((windowDelta = sessionRecv - 65535) > 0) {
                session.updateRecvWindow(windowDelta);
                session.frames(null, this, prefaceFrame, settingsFrame, new WindowUpdateFrame(0, windowDelta));
            } else {
                session.frames(null, this, prefaceFrame, settingsFrame);
            }
            super.onOpen();
        }

        @Override
        public void succeeded() {
            this.promise.succeeded(this.getSession());
        }

        @Override
        public void failed(Throwable x) {
            this.close();
            this.promise.failed(x);
        }
    }
}

