/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QuotedQualityCSV
implements Iterable<String> {
    private static final Double ZERO = new Double(0.0);
    private static final Double ONE = new Double(1.0);
    private final List<String> _values = new ArrayList<String>();
    private final List<Double> _quality = new ArrayList<Double>();
    private boolean _sorted = false;

    public QuotedQualityCSV(String ... values) {
        for (String v : values) {
            this.addValue(v);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addValue(String value) {
        buffer = new StringBuffer();
        l = value.length();
        state = State.VALUE;
        quoted = false;
        sloshed = false;
        nws_length = 0;
        last_length = 0;
        q = QuotedQualityCSV.ONE;
        block19: for (i = 0; i <= l; ++i) {
            block25: {
                block26: {
                    v0 = c = i == l ? '\u0000' : value.charAt(i);
                    if (!quoted || c == '\u0000') break block25;
                    if (!sloshed) break block26;
                    sloshed = false;
                    ** GOTO lbl-1000
                }
                switch (c) {
                    case '\\': {
                        sloshed = true;
                        ** GOTO lbl23
                    }
                    case '\"': {
                        quoted = false;
                        if (state == State.Q_VALUE) break;
                    }
lbl23:
                    // 3 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        buffer.append(c);
                        nws_length = buffer.length();
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\t': 
                case ' ': {
                    if (buffer.length() <= last_length) continue block19;
                    buffer.append(c);
                    continue block19;
                }
                case '\"': {
                    quoted = true;
                    if (state == State.Q_VALUE) continue block19;
                    buffer.append(c);
                    nws_length = buffer.length();
                    continue block19;
                }
                case ';': {
                    if (state == State.Q_VALUE) {
                        try {
                            q = new Double(buffer.substring(last_length));
                        }
                        catch (Exception e) {
                            q = QuotedQualityCSV.ZERO;
                        }
                        nws_length = last_length;
                    }
                    buffer.setLength(nws_length);
                    buffer.append(c);
                    last_length = ++nws_length;
                    state = State.PARAM_NAME;
                    continue block19;
                }
                case '\u0000': 
                case ',': {
                    if (state == State.Q_VALUE) {
                        try {
                            q = new Double(buffer.substring(last_length));
                        }
                        catch (Exception e) {
                            q = QuotedQualityCSV.ZERO;
                        }
                        nws_length = last_length;
                    }
                    buffer.setLength(nws_length);
                    if (q > 0.0 && nws_length > 0) {
                        this._values.add(buffer.toString());
                        this._quality.add(q);
                        this._sorted = false;
                    }
                    buffer.setLength(0);
                    last_length = 0;
                    nws_length = 0;
                    q = QuotedQualityCSV.ONE;
                    state = State.VALUE;
                    continue block19;
                }
                default: {
                    switch (1.$SwitchMap$org$eclipse$jetty$http$QuotedQualityCSV$State[state.ordinal()]) {
                        case 1: {
                            buffer.append(c);
                            nws_length = buffer.length();
                            continue block19;
                        }
                        case 2: {
                            if (c == '=') {
                                buffer.setLength(nws_length);
                                if (nws_length - last_length == 1 && Character.toLowerCase(buffer.charAt(last_length)) == 'q') {
                                    buffer.setLength(last_length - 1);
                                    last_length = nws_length = buffer.length();
                                    state = State.Q_VALUE;
                                    continue block19;
                                }
                                buffer.append(c);
                                last_length = ++nws_length;
                                state = State.PARAM_VALUE;
                                continue block19;
                            }
                            buffer.append(c);
                            nws_length = buffer.length();
                            continue block19;
                        }
                        case 3: 
                        case 4: {
                            buffer.append(c);
                            nws_length = buffer.length();
                            continue block19;
                        }
                    }
                }
            }
        }
    }

    public List<String> getValues() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values;
    }

    @Override
    public Iterator<String> iterator() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values.iterator();
    }

    protected void sort() {
        this._sorted = true;
        Double last = ZERO;
        int len = Integer.MIN_VALUE;
        int i = this._values.size();
        while (i-- > 0) {
            String v = this._values.get(i);
            Double q = this._quality.get(i);
            int compare = last.compareTo(q);
            if (compare > 0 || compare == 0 && v.length() < len) {
                this._values.set(i, this._values.get(i + 1));
                this._values.set(i + 1, v);
                this._quality.set(i, this._quality.get(i + 1));
                this._quality.set(i + 1, q);
                last = ZERO;
                len = 0;
                i = this._values.size();
                continue;
            }
            last = q;
            len = v.length();
        }
    }

    private static enum State {
        VALUE,
        PARAM_NAME,
        PARAM_VALUE,
        Q_VALUE;

    }
}

