/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.FormatConfig;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser.JodaDateSerializerBase;
import com.facebook.presto.jdbc.internal.joda.time.LocalDate;
import java.io.IOException;

public class LocalDateSerializer
extends JodaDateSerializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;

    public LocalDateSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATEONLY_FORMAT);
    }

    public LocalDateSerializer(JacksonJodaDateFormat format) {
        super(LocalDate.class, format, true, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public LocalDateSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new LocalDateSerializer(formatter);
    }

    @Override
    public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeStartArray();
            gen.writeNumber(value.year().get());
            gen.writeNumber(value.monthOfYear().get());
            gen.writeNumber(value.dayOfMonth().get());
            gen.writeEndArray();
        } else {
            gen.writeString(this._format.createFormatter(provider).print(value));
        }
    }
}

