/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.guava.base;

import com.facebook.presto.jdbc.internal.guava.annotations.GwtCompatible;
import com.facebook.presto.jdbc.internal.guava.base.CharMatcher;
import com.facebook.presto.jdbc.internal.guava.base.Enums;
import com.facebook.presto.jdbc.internal.guava.base.Optional;
import java.lang.ref.WeakReference;

@GwtCompatible(emulated=true)
final class Platform {
    private Platform() {
    }

    static long systemNanoTime() {
        return System.nanoTime();
    }

    static CharMatcher precomputeCharMatcher(CharMatcher matcher) {
        return matcher.precomputedInternal();
    }

    static <T extends Enum<T>> Optional<T> getEnumIfPresent(Class<T> enumClass, String value) {
        WeakReference<Enum<?>> ref = Enums.getEnumConstants(enumClass).get(value);
        return ref == null ? Optional.absent() : Optional.of(enumClass.cast(ref.get()));
    }
}

