/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.classloader;

import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorRecordSetProvider;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorSplit;
import com.facebook.presto.jdbc.internal.spi.RecordSet;
import com.facebook.presto.jdbc.internal.spi.classloader.ClassLoaderSafeRecordSet;
import com.facebook.presto.jdbc.internal.spi.classloader.ThreadContextClassLoader;
import java.util.List;
import java.util.Objects;

public class ClassLoaderSafeConnectorRecordSetProvider
implements ConnectorRecordSetProvider {
    private final ConnectorRecordSetProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorRecordSetProvider(ConnectorRecordSetProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public RecordSet getRecordSet(ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeRecordSet classLoaderSafeRecordSet = new ClassLoaderSafeRecordSet(this.delegate.getRecordSet(session, split, columns), this.classLoader);
            return classLoaderSafeRecordSet;
        }
    }

    public String toString() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            String string = this.delegate.toString();
            return string;
        }
    }
}

