/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.http;

import com.facebook.presto.jdbc.internal.jetty.http.BadMessageException;
import com.facebook.presto.jdbc.internal.jetty.http.HttpField;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.util.StringUtil;

public class HostPortHttpField
extends HttpField {
    private final String _host;
    private final int _port;

    public HostPortHttpField(String authority) {
        this(HttpHeader.HOST, HttpHeader.HOST.asString(), authority);
    }

    public HostPortHttpField(HttpHeader header, String name, String authority) {
        super(header, name, authority);
        if (authority == null || authority.length() == 0) {
            throw new IllegalArgumentException("No Authority");
        }
        try {
            if (authority.charAt(0) == '[') {
                int close = authority.lastIndexOf(93);
                if (close < 0) {
                    throw new BadMessageException(400, "Bad ipv6");
                }
                this._host = authority.substring(0, close + 1);
                if (authority.length() > close + 1) {
                    if (authority.charAt(close + 1) != ':') {
                        throw new BadMessageException(400, "Bad ipv6 port");
                    }
                    this._port = StringUtil.toInt(authority, close + 2);
                } else {
                    this._port = 0;
                }
            } else {
                int c = authority.lastIndexOf(58);
                if (c >= 0) {
                    this._host = authority.substring(0, c);
                    this._port = StringUtil.toInt(authority, c + 1);
                } else {
                    this._host = authority;
                    this._port = 0;
                }
            }
        }
        catch (BadMessageException bm) {
            throw bm;
        }
        catch (Exception e) {
            throw new BadMessageException(400, "Bad HostPort", e);
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }
}

