/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client;

import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpConversation;
import com.facebook.presto.jdbc.internal.jetty.client.HttpDestination;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequest;
import com.facebook.presto.jdbc.internal.jetty.client.HttpResponseException;
import com.facebook.presto.jdbc.internal.jetty.client.Origin;
import com.facebook.presto.jdbc.internal.jetty.client.ProxyConfiguration;
import com.facebook.presto.jdbc.internal.jetty.client.api.Connection;
import com.facebook.presto.jdbc.internal.jetty.client.api.Destination;
import com.facebook.presto.jdbc.internal.jetty.client.api.Request;
import com.facebook.presto.jdbc.internal.jetty.client.api.Response;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpConnectionOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.http.HttpHeader;
import com.facebook.presto.jdbc.internal.jetty.http.HttpMethod;
import com.facebook.presto.jdbc.internal.jetty.http.HttpScheme;
import com.facebook.presto.jdbc.internal.jetty.io.ClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.io.ssl.SslClientConnectionFactory;
import com.facebook.presto.jdbc.internal.jetty.util.Promise;
import com.facebook.presto.jdbc.internal.jetty.util.log.Log;
import com.facebook.presto.jdbc.internal.jetty.util.log.Logger;
import com.facebook.presto.jdbc.internal.jetty.util.ssl.SslContextFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpProxy
extends ProxyConfiguration.Proxy {
    private static final Logger LOG = Log.getLogger(HttpProxy.class);

    public HttpProxy(String host, int port) {
        this(new Origin.Address(host, port), false);
    }

    public HttpProxy(Origin.Address address, boolean secure) {
        super(address, secure);
    }

    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new HttpProxyClientConnectionFactory(connectionFactory);
    }

    @Override
    public URI getURI() {
        String scheme = this.isSecure() ? HttpScheme.HTTPS.asString() : HttpScheme.HTTP.asString();
        return URI.create(new Origin(scheme, this.getAddress()).asString());
    }

    private class TunnelPromise
    implements Promise<Connection> {
        private final Request request;
        private final Response.CompleteListener listener;
        private final Promise<Connection> promise;

        private TunnelPromise(Request request, Response.CompleteListener listener, Promise<Connection> promise) {
            this.request = request;
            this.listener = listener;
            this.promise = promise;
        }

        @Override
        public void succeeded(Connection connection) {
            connection.send(this.request, this.listener);
        }

        @Override
        public void failed(Throwable x) {
            this.promise.failed(x);
        }

        private void setEndPoint(EndPoint endPoint) {
            HttpConversation conversation = ((HttpRequest)this.request).getConversation();
            conversation.setAttribute(EndPoint.class.getName(), endPoint);
        }
    }

    private class ProxyConnection
    implements Connection {
        private final Destination destination;
        private final Connection connection;
        private final Promise<Connection> promise;

        private ProxyConnection(Destination destination, Connection connection, Promise<Connection> promise) {
            this.destination = destination;
            this.connection = connection;
            this.promise = promise;
        }

        @Override
        public void send(Request request, Response.CompleteListener listener) {
            if (this.connection.isClosed()) {
                this.destination.newConnection(new TunnelPromise(request, listener, this.promise));
            } else {
                this.connection.send(request, listener);
            }
        }

        @Override
        public void close() {
            this.connection.close();
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }
    }

    private class CreateTunnelPromise
    implements Promise<Connection> {
        private final ClientConnectionFactory connectionFactory;
        private final EndPoint endPoint;
        private final Promise<Connection> promise;
        private final Map<String, Object> context;

        private CreateTunnelPromise(ClientConnectionFactory connectionFactory, EndPoint endPoint, Promise<Connection> promise, Map<String, Object> context) {
            this.connectionFactory = connectionFactory;
            this.endPoint = endPoint;
            this.promise = promise;
            this.context = context;
        }

        @Override
        public void succeeded(Connection connection) {
            HttpDestination destination = (HttpDestination)this.context.get("http.destination");
            this.tunnel(destination, connection);
        }

        @Override
        public void failed(Throwable x) {
            this.tunnelFailed(this.endPoint, x);
        }

        private void tunnel(HttpDestination destination, Connection connection) {
            String target = destination.getOrigin().getAddress().asString();
            Origin.Address proxyAddress = destination.getConnectAddress();
            HttpClient httpClient = destination.getHttpClient();
            long connectTimeout = httpClient.getConnectTimeout();
            Request connect = httpClient.newRequest(proxyAddress.getHost(), proxyAddress.getPort()).method(HttpMethod.CONNECT).path(target).header(HttpHeader.HOST, target).idleTimeout(2L * connectTimeout, TimeUnit.MILLISECONDS).timeout(connectTimeout, TimeUnit.MILLISECONDS);
            HttpConversation conversation = ((HttpRequest)connect).getConversation();
            conversation.setAttribute(EndPoint.class.getName(), this.endPoint);
            connect.attribute(Connection.class.getName(), new ProxyConnection(destination, connection, this.promise));
            connection.send(connect, result -> {
                EndPoint endPoint = (EndPoint)conversation.getAttribute(EndPoint.class.getName());
                if (result.isSucceeded()) {
                    Response response = result.getResponse();
                    if (response.getStatus() == 200) {
                        this.tunnelSucceeded(endPoint);
                    } else {
                        HttpResponseException failure = new HttpResponseException("Unexpected " + response + " for " + result.getRequest(), response);
                        this.tunnelFailed(endPoint, failure);
                    }
                } else {
                    this.tunnelFailed(endPoint, result.getFailure());
                }
            });
        }

        private void tunnelSucceeded(EndPoint endPoint) {
            try {
                this.context.put("http.connection.promise", this.promise);
                HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                HttpClient client = destination.getHttpClient();
                SslClientConnectionFactory sslConnectionFactory = new SslClientConnectionFactory(client.getSslContextFactory(), client.getByteBufferPool(), client.getExecutor(), this.connectionFactory);
                HttpConnectionOverHTTP oldConnection = (HttpConnectionOverHTTP)endPoint.getConnection();
                com.facebook.presto.jdbc.internal.jetty.io.Connection newConnection = sslConnectionFactory.newConnection(endPoint, this.context);
                endPoint.setConnection(oldConnection);
                endPoint.upgrade(newConnection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP tunnel established: {} over {}", oldConnection, newConnection);
                }
            }
            catch (Throwable x) {
                this.tunnelFailed(endPoint, x);
            }
        }

        private void tunnelFailed(EndPoint endPoint, Throwable failure) {
            endPoint.close();
            this.promise.failed(failure);
        }
    }

    private class HttpProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private final ClientConnectionFactory connectionFactory;

        private HttpProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public com.facebook.presto.jdbc.internal.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            boolean secure = HttpScheme.HTTPS.is(destination.getScheme());
            SslContextFactory sslContextFactory = destination.getHttpClient().getSslContextFactory();
            if (secure) {
                if (sslContextFactory != null) {
                    Promise promise;
                    Promise wrapped = promise = (Promise)context.get("http.connection.promise");
                    if (promise instanceof Promise.Wrapper) {
                        wrapped = ((Promise.Wrapper)promise).unwrap();
                    }
                    if (wrapped instanceof TunnelPromise) {
                        ((TunnelPromise)wrapped).setEndPoint(endPoint);
                        return this.connectionFactory.newConnection(endPoint, context);
                    }
                    CreateTunnelPromise tunnelPromise = new CreateTunnelPromise(this.connectionFactory, endPoint, promise, context);
                    context.put("http.connection.promise", tunnelPromise);
                    return this.connectionFactory.newConnection(endPoint, context);
                }
                throw new IOException("Cannot tunnel request, missing " + SslContextFactory.class.getName() + " in " + HttpClient.class.getName());
            }
            return this.connectionFactory.newConnection(endPoint, context);
        }
    }
}

