/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.SerializerProvider;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.FormatConfig;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.ser.JodaDateSerializerBase;
import com.facebook.presto.jdbc.internal.joda.time.Instant;
import java.io.IOException;

public class InstantSerializer
extends JodaDateSerializerBase<Instant> {
    private static final long serialVersionUID = 1L;

    public InstantSerializer() {
        this(FormatConfig.DEFAULT_TIMEONLY_FORMAT);
    }

    public InstantSerializer(JacksonJodaDateFormat format) {
        super(Instant.class, format, false, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    public InstantSerializer withFormat(JacksonJodaDateFormat formatter) {
        return this._format == formatter ? this : new InstantSerializer(formatter);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Instant value) {
        return value.getMillis() == 0L;
    }

    @Override
    public void serialize(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._useTimestamp(provider)) {
            gen.writeNumber(value.getMillis());
        } else {
            gen.writeString(value.toString());
        }
    }
}

