/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.databind.jsontype.impl;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonTypeInfo;
import com.facebook.presto.jdbc.internal.jackson.core.JsonGenerator;
import com.facebook.presto.jdbc.internal.jackson.databind.BeanProperty;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeIdResolver;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import java.io.IOException;

public class AsExistingPropertyTypeSerializer
extends AsPropertyTypeSerializer {
    public AsExistingPropertyTypeSerializer(TypeIdResolver idRes, BeanProperty property, String propName) {
        super(idRes, property, propName);
    }

    @Override
    public AsExistingPropertyTypeSerializer forProperty(BeanProperty prop) {
        return this._property == prop ? this : new AsExistingPropertyTypeSerializer(this._idResolver, prop, this._typePropertyName);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.EXISTING_PROPERTY;
    }

    @Override
    public void writeTypePrefixForObject(Object value, JsonGenerator gen) throws IOException {
        String typeId = this.idFromValue(value);
        if (typeId != null && gen.canWriteTypeId()) {
            gen.writeTypeId(typeId);
        }
        gen.writeStartObject();
    }

    @Override
    public void writeTypePrefixForObject(Object value, JsonGenerator gen, Class<?> type) throws IOException {
        String typeId = this.idFromValueAndType(value, type);
        if (typeId != null && gen.canWriteTypeId()) {
            gen.writeTypeId(typeId);
        }
        gen.writeStartObject();
    }

    @Override
    public void writeCustomTypePrefixForObject(Object value, JsonGenerator gen, String typeId) throws IOException {
        if (typeId != null && gen.canWriteTypeId()) {
            gen.writeTypeId(typeId);
        }
        gen.writeStartObject();
    }
}

