/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.slice;

import com.facebook.presto.jdbc.internal.airlift.slice.CountingOutputStream;
import com.facebook.presto.jdbc.internal.airlift.slice.LittleEndianDataOutputStream;
import com.facebook.presto.jdbc.internal.airlift.slice.Preconditions;
import com.facebook.presto.jdbc.internal.airlift.slice.RuntimeIOException;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceStreamUtils;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class OutputStreamSliceOutput
extends SliceOutput {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OutputStreamSliceOutput.class).instanceSize();
    private final CountingOutputStream countingOutputStream;
    private final LittleEndianDataOutputStream dataOutputStream;

    public OutputStreamSliceOutput(OutputStream outputStream) {
        Preconditions.checkNotNull(outputStream, "outputStream is null");
        this.countingOutputStream = new CountingOutputStream(outputStream);
        this.dataOutputStream = new LittleEndianDataOutputStream(this.countingOutputStream);
    }

    @Override
    public void flush() throws IOException {
        this.countingOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.countingOutputStream.close();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("OutputStream can not be reset");
    }

    @Override
    public int size() {
        return OutputStreamSliceOutput.checkedCast(this.countingOutputStream.getCount());
    }

    @Override
    public int getRetainedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public int writableBytes() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void writeByte(int value) {
        try {
            this.dataOutputStream.writeByte(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeShort(int value) {
        try {
            this.dataOutputStream.writeShort(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeInt(int value) {
        try {
            this.dataOutputStream.writeInt(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeLong(long value) {
        try {
            this.dataOutputStream.writeLong(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeFloat(float value) {
        try {
            this.dataOutputStream.writeFloat(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeDouble(double value) {
        try {
            this.dataOutputStream.writeDouble(value);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    @Override
    public void writeBytes(Slice source, int sourceIndex, int length) {
        try {
            source.getBytes(sourceIndex, this.dataOutputStream, length);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    @Override
    public void writeBytes(byte[] source, int sourceIndex, int length) {
        try {
            this.dataOutputStream.write(source, sourceIndex, length);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeBytes(InputStream in, int length) throws IOException {
        SliceStreamUtils.copyStreamFully(in, this, length);
    }

    @Override
    public SliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    @Override
    public SliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    @Override
    public SliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    @Override
    public SliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public SliceOutput appendByte(int value) {
        this.writeByte(value);
        return this;
    }

    @Override
    public SliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public SliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    @Override
    public SliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    @Override
    public Slice slice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getUnderlyingSlice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Charset charset) {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BasicSliceOutput{");
        builder.append("countingOutputStream=").append(this.countingOutputStream);
        builder.append(", dataOutputStream=").append(this.dataOutputStream);
        builder.append('}');
        return builder.toString();
    }

    private static int checkedCast(long value) {
        int result = (int)value;
        Preconditions.checkArgument((long)result == value, "Size is greater than maximum int value");
        return result;
    }
}

