/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.concurrent;

import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.FutureCallback;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.Futures;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.ListenableFuture;
import com.facebook.presto.jdbc.internal.guava.util.concurrent.SettableFuture;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AsyncSemaphore<T> {
    private final Queue<QueuedTask<T>> queuedTasks = new ConcurrentLinkedQueue<QueuedTask<T>>();
    private final AtomicInteger counter = new AtomicInteger();
    private final Runnable runNextTask = this::runNext;
    private final int maxPermits;
    private final Executor submitExecutor;
    private final Function<T, ListenableFuture<?>> submitter;

    public AsyncSemaphore(int maxPermits, Executor submitExecutor, Function<T, ListenableFuture<?>> submitter) {
        Preconditions.checkArgument(maxPermits > 0, "must have at least one permit");
        this.maxPermits = maxPermits;
        this.submitExecutor = Preconditions.checkNotNull(submitExecutor, "submitExecutor is null");
        this.submitter = Preconditions.checkNotNull(submitter, "submitter is null");
    }

    public ListenableFuture<?> submit(T task) {
        QueuedTask queuedTask = new QueuedTask(task);
        this.queuedTasks.add(queuedTask);
        this.acquirePermit();
        return queuedTask.getCompletionFuture();
    }

    private void acquirePermit() {
        if (this.counter.incrementAndGet() <= this.maxPermits) {
            this.submitExecutor.execute(this.runNextTask);
        }
    }

    private void releasePermit() {
        if (this.counter.getAndDecrement() > this.maxPermits) {
            this.submitExecutor.execute(this.runNextTask);
        }
    }

    private void runNext() {
        final QueuedTask<T> queuedTask = this.queuedTasks.poll();
        ListenableFuture<?> future = this.submitTask(queuedTask.getTask());
        Futures.addCallback(future, new FutureCallback<Object>(){

            @Override
            public void onSuccess(Object result) {
                queuedTask.markCompleted();
                AsyncSemaphore.this.releasePermit();
            }

            @Override
            public void onFailure(Throwable t) {
                queuedTask.markFailure(t);
                AsyncSemaphore.this.releasePermit();
            }
        });
    }

    private ListenableFuture<?> submitTask(T task) {
        try {
            ListenableFuture<?> future = this.submitter.apply(task);
            if (future == null) {
                return Futures.immediateFailedFuture(new NullPointerException("Submitter returned a null future for task: " + task));
            }
            return future;
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture(e);
        }
    }

    private static class QueuedTask<T> {
        private final T task;
        private final SettableFuture<?> settableFuture = SettableFuture.create();

        private QueuedTask(T task) {
            this.task = Preconditions.checkNotNull(task, "task is null");
        }

        public T getTask() {
            return this.task;
        }

        public void markFailure(Throwable throwable) {
            this.settableFuture.setException(throwable);
        }

        public void markCompleted() {
            this.settableFuture.set(null);
        }

        public ListenableFuture<?> getCompletionFuture() {
            return this.settableFuture;
        }
    }
}

