/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import com.facebook.presto.jdbc.internal.spi.type.DateTimeEncoding;
import com.facebook.presto.jdbc.internal.spi.type.TimeZoneIndex;
import com.facebook.presto.jdbc.internal.spi.type.TimeZoneKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public final class SqlTimestampWithTimeZone {
    private final long millisUtc;
    private final TimeZoneKey timeZoneKey;

    public SqlTimestampWithTimeZone(long timestampWithTimeZone) {
        this.millisUtc = DateTimeEncoding.unpackMillisUtc(timestampWithTimeZone);
        this.timeZoneKey = DateTimeEncoding.unpackZoneKey(timestampWithTimeZone);
    }

    public SqlTimestampWithTimeZone(long millisUtc, TimeZoneKey timeZoneKey) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = timeZoneKey;
    }

    public SqlTimestampWithTimeZone(long millisUtc, TimeZone timeZone) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = TimeZoneKey.getTimeZoneKey(timeZone.getID());
    }

    public long getMillisUtc() {
        return this.millisUtc;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.millisUtc, this.timeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTimestampWithTimeZone other = (SqlTimestampWithTimeZone)obj;
        return Objects.equals(this.millisUtc, other.millisUtc) && Objects.equals(this.timeZoneKey, other.timeZoneKey);
    }

    @JsonValue
    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        format.setTimeZone(TimeZoneIndex.getTimeZoneForKey(this.timeZoneKey));
        return format.format(new Date(this.millisUtc)) + " " + this.timeZoneKey.getId();
    }
}

