/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonValue;
import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Optional;

@JsonDeserialize(using=JsonDeserializer.class)
public enum ParameterKind {
    TYPE(Optional.of("TYPE_SIGNATURE")),
    NAMED_TYPE(Optional.of("NAMED_TYPE_SIGNATURE")),
    LONG(Optional.of("LONG_LITERAL")),
    LITERAL_CALCULATION(Optional.empty());

    private final Optional<String> oldName;

    private ParameterKind(Optional<String> oldName) {
        this.oldName = oldName;
    }

    @JsonValue
    public String jsonName() {
        return this.oldName.orElse(this.name());
    }

    public static class JsonDeserializer
    extends com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer<ParameterKind> {
        @Override
        public ParameterKind deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String textValue = jp.getText();
            for (ParameterKind kind : ParameterKind.values()) {
                if (kind.oldName.isPresent() && ((String)kind.oldName.get()).equals(textValue)) {
                    return kind;
                }
                if (!kind.name().equals(textValue)) continue;
                return kind;
            }
            throw new IllegalArgumentException("Can not deserialize ParameterKind for value '" + textValue + "'");
        }
    }
}

