/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractType;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import com.facebook.presto.jdbc.internal.spi.type.VariableWidthType;

public abstract class AbstractVariableWidthType
extends AbstractType
implements VariableWidthType {
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;

    protected AbstractVariableWidthType(TypeSignature signature, Class<?> javaType) {
        super(signature, javaType);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new VariableWidthBlockBuilder(blockBuilderStatus, expectedBytesPerEntry == 0 ? expectedEntries : Math.min(expectedEntries, blockBuilderStatus.getMaxBlockSizeInBytes() / expectedBytesPerEntry), expectedBytesPerEntry);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 32);
    }
}

