/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockValidationUtil;
import java.util.List;

public class VariableWidthBlock
extends AbstractVariableWidthBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlock.class).instanceSize();
    private final int positionCount;
    private final Slice slice;
    private final Slice offsets;
    private final Slice valueIsNull;

    public VariableWidthBlock(int positionCount, Slice slice, Slice offsets, Slice valueIsNull) {
        this.positionCount = positionCount;
        this.slice = slice;
        if (offsets.length() < (positionCount + 1) * 4) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        this.offsets = offsets;
        if (valueIsNull.length() < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
    }

    @Override
    protected final int getPositionOffset(int position) {
        return this.offsets.getInt(position * 4);
    }

    @Override
    public int getLength(int position) {
        return this.getPositionOffset(position + 1) - this.getPositionOffset(position);
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull.getByte(position) != 0;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        long size = this.slice.length() + this.offsets.length() + this.valueIsNull.length();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public int getRetainedSizeInBytes() {
        long size = INSTANCE_SIZE + this.slice.getRetainedSize() + this.offsets.getRetainedSize() + this.valueIsNull.getRetainedSize();
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockValidationUtil.checkValidPositions(positions, this.positionCount);
        int finalLength = positions.stream().mapToInt(this::getLength).sum();
        SliceOutput newSlice = Slices.allocate(finalLength).getOutput();
        SliceOutput newOffsets = Slices.allocate(positions.size() * 4 + 4).getOutput();
        SliceOutput newValueIsNull = Slices.allocate(positions.size()).getOutput();
        newOffsets.appendInt(0);
        for (int position : positions) {
            boolean isNull = this.isEntryNull(position);
            newValueIsNull.appendByte(isNull ? 1 : 0);
            if (!isNull) {
                newSlice.appendBytes(this.slice.getBytes(this.getPositionOffset(position), this.getLength(position)));
            }
            newOffsets.appendInt(newSlice.size());
        }
        return new VariableWidthBlock(positions.size(), newSlice.slice(), newOffsets.slice(), newValueIsNull.slice());
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.slice;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice newOffsets = this.offsets.slice(positionOffset * 4, (length + 1) * 4);
        Slice newValueIsNull = this.valueIsNull.slice(positionOffset, length);
        return new VariableWidthBlock(length, this.slice, newOffsets, newValueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        SliceOutput newOffsets = Slices.allocate(length * 4 + 4).getOutput();
        newOffsets.appendInt(0);
        int sliceLength = 0;
        for (int position = positionOffset; position < positionOffset + length; ++position) {
            newOffsets.appendInt(sliceLength += this.getLength(position));
        }
        Slice newSlice = Slices.copyOf(this.slice, this.getPositionOffset(positionOffset), sliceLength);
        Slice newValueIsNull = Slices.copyOf(this.valueIsNull, positionOffset, length);
        return new VariableWidthBlock(length, newSlice, newOffsets.slice(), newValueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append(", slice=").append(this.slice);
        sb.append('}');
        return sb.toString();
    }
}

