/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.DictionaryBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.LazySliceArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.SliceArrayBlockEncoding;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;

public class LazySliceArrayBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<LazySliceArrayBlockEncoding> FACTORY = new LazySliceArrayBlockEncodingFactory();
    private static final String NAME = "LAZY_SLICE_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        boolean isDictionary = sliceInput.readBoolean();
        if (isDictionary) {
            return new DictionaryBlockEncoding(new SliceArrayBlockEncoding()).readBlock(sliceInput);
        }
        return new SliceArrayBlockEncoding().readBlock(sliceInput);
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        LazySliceArrayBlock sliceArrayBlock = (LazySliceArrayBlock)block;
        sliceOutput.writeBoolean(sliceArrayBlock.isDictionary());
        Block nonLazyBlock = sliceArrayBlock.createNonLazyBlock();
        nonLazyBlock.getEncoding().writeBlock(sliceOutput, nonLazyBlock);
    }

    @Override
    public int getEstimatedSize(Block block) {
        int positionCount = block.getPositionCount();
        int size = 4;
        int totalLength = 0;
        for (int position = 0; position < positionCount; ++position) {
            if (!block.isNull(position)) {
                totalLength += block.getLength(position);
            }
            size += 4;
        }
        size += positionCount / 8 + 1;
        return size += totalLength;
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class LazySliceArrayBlockEncodingFactory
    implements BlockEncodingFactory<LazySliceArrayBlockEncoding> {
        @Override
        public String getName() {
            return LazySliceArrayBlockEncoding.NAME;
        }

        @Override
        public LazySliceArrayBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            return new LazySliceArrayBlockEncoding();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, LazySliceArrayBlockEncoding blockEncoding) {
        }
    }
}

