/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.AbstractInterleavedBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.InterleavedBlock;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;

public class InterleavedBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<InterleavedBlockEncoding> FACTORY = new InterleavedBlockEncodingFactory();
    private static final String NAME = "INTERLEAVED";
    private final BlockEncoding[] individualBlockEncodings;

    public InterleavedBlockEncoding(BlockEncoding[] individualBlockEncodings) {
        this.individualBlockEncodings = individualBlockEncodings;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        AbstractInterleavedBlock interleavedBlock = (AbstractInterleavedBlock)block;
        if (interleavedBlock.getBlockCount() != this.individualBlockEncodings.length) {
            throw new IllegalArgumentException("argument block differs in length (" + interleavedBlock.getBlockCount() + ") with this encoding (" + this.individualBlockEncodings.length + ")");
        }
        for (int i = 0; i < this.individualBlockEncodings.length; ++i) {
            this.individualBlockEncodings[i].writeBlock(sliceOutput, interleavedBlock.getBlock(i));
        }
    }

    @Override
    public int getEstimatedSize(Block block) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        Block[] individualBlocks = new Block[this.individualBlockEncodings.length];
        for (int i = 0; i < this.individualBlockEncodings.length; ++i) {
            individualBlocks[i] = this.individualBlockEncodings[i].readBlock(sliceInput);
        }
        return new InterleavedBlock(individualBlocks);
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public static class InterleavedBlockEncodingFactory
    implements BlockEncodingFactory<InterleavedBlockEncoding> {
        @Override
        public String getName() {
            return InterleavedBlockEncoding.NAME;
        }

        @Override
        public InterleavedBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            int individualBlockEncodingsCount = input.readInt();
            BlockEncoding[] individualBlockEncodings = new BlockEncoding[individualBlockEncodingsCount];
            for (int i = 0; i < individualBlockEncodingsCount; ++i) {
                individualBlockEncodings[i] = serde.readBlockEncoding(input);
            }
            return new InterleavedBlockEncoding(individualBlockEncodings);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, InterleavedBlockEncoding blockEncoding) {
            output.appendInt(blockEncoding.individualBlockEncodings.length);
            for (BlockEncoding individualBlockEncoding : blockEncoding.individualBlockEncodings) {
                serde.writeBlockEncoding(output, individualBlockEncoding);
            }
        }
    }
}

