/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jetty.client.http;

import com.facebook.presto.jdbc.internal.jetty.client.HttpClient;
import com.facebook.presto.jdbc.internal.jetty.client.HttpContent;
import com.facebook.presto.jdbc.internal.jetty.client.HttpExchange;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequest;
import com.facebook.presto.jdbc.internal.jetty.client.HttpRequestException;
import com.facebook.presto.jdbc.internal.jetty.client.HttpSender;
import com.facebook.presto.jdbc.internal.jetty.client.api.ContentProvider;
import com.facebook.presto.jdbc.internal.jetty.client.http.HttpChannelOverHTTP;
import com.facebook.presto.jdbc.internal.jetty.http.HttpGenerator;
import com.facebook.presto.jdbc.internal.jetty.http.HttpURI;
import com.facebook.presto.jdbc.internal.jetty.http.MetaData;
import com.facebook.presto.jdbc.internal.jetty.io.ByteBufferPool;
import com.facebook.presto.jdbc.internal.jetty.io.EndPoint;
import com.facebook.presto.jdbc.internal.jetty.util.Callback;
import com.facebook.presto.jdbc.internal.jetty.util.IteratingCallback;
import java.nio.ByteBuffer;

public class HttpSenderOverHTTP
extends HttpSender {
    private final HttpGenerator generator = new HttpGenerator();

    public HttpSenderOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            new HeadersCallback(exchange, content, callback).iterate();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            callback.failed(x);
        }
    }

    @Override
    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            HttpClient client = this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            ByteBuffer chunk = null;
            block9: while (true) {
                ByteBuffer contentBuffer = content.getByteBuffer();
                boolean lastContent = content.isLast();
                HttpGenerator.Result result = this.generator.generateRequest(null, null, chunk, contentBuffer, lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated content ({} bytes) - {}/{}", new Object[]{contentBuffer == null ? -1 : contentBuffer.remaining(), result, this.generator});
                }
                switch (result) {
                    case NEED_CHUNK: {
                        chunk = bufferPool.acquire(12, false);
                        break;
                    }
                    case FLUSH: {
                        EndPoint endPoint = this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (chunk != null) {
                            endPoint.write(new ByteBufferRecyclerCallback(callback, bufferPool, new ByteBuffer[]{chunk}), chunk, contentBuffer);
                        } else {
                            endPoint.write(callback, contentBuffer);
                        }
                        return;
                    }
                    case SHUTDOWN_OUT: {
                        this.shutdownOutput();
                        break;
                    }
                    case CONTINUE: {
                        if (lastContent) continue block9;
                        callback.succeeded();
                        return;
                    }
                    case DONE: {
                        callback.succeeded();
                        return;
                    }
                    default: {
                        throw new IllegalStateException(result.toString());
                    }
                }
            }
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            callback.failed(x);
            return;
        }
    }

    @Override
    protected void reset() {
        this.generator.reset();
        super.reset();
    }

    @Override
    protected void dispose() {
        this.generator.abort();
        super.dispose();
        this.shutdownOutput();
    }

    private void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request shutdown output {}", this.getHttpExchange().getRequest());
        }
        this.getHttpChannel().getHttpConnection().getEndPoint().shutdownOutput();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.generator);
    }

    private class ByteBufferRecyclerCallback
    implements Callback {
        private final Callback callback;
        private final ByteBufferPool pool;
        private final ByteBuffer[] buffers;

        private ByteBufferRecyclerCallback(Callback callback, ByteBufferPool pool, ByteBuffer ... buffers) {
            this.callback = callback;
            this.pool = pool;
            this.buffers = buffers;
        }

        @Override
        public boolean isNonBlocking() {
            return this.callback.isNonBlocking();
        }

        @Override
        public void succeeded() {
            for (ByteBuffer buffer : this.buffers) {
                assert (!buffer.hasRemaining());
                this.pool.release(buffer);
            }
            this.callback.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            for (ByteBuffer buffer : this.buffers) {
                this.pool.release(buffer);
            }
            this.callback.failed(x);
        }
    }

    private class HeadersCallback
    extends IteratingCallback {
        private final HttpExchange exchange;
        private final Callback callback;
        private final MetaData.Request metaData;
        private ByteBuffer headerBuffer;
        private ByteBuffer chunkBuffer;
        private ByteBuffer contentBuffer;
        private boolean lastContent;
        private boolean generated;

        public HeadersCallback(HttpExchange exchange, HttpContent content, Callback callback) {
            super(false);
            this.exchange = exchange;
            this.callback = callback;
            HttpRequest request = exchange.getRequest();
            ContentProvider requestContent = request.getContent();
            long contentLength = requestContent == null ? -1L : requestContent.getLength();
            String path = request.getPath();
            String query = request.getQuery();
            if (query != null) {
                path = path + "?" + query;
            }
            this.metaData = new MetaData.Request(request.getMethod(), new HttpURI(path), request.getVersion(), request.getHeaders(), contentLength);
            if (!HttpSenderOverHTTP.this.expects100Continue(request)) {
                content.advance();
                this.contentBuffer = content.getByteBuffer();
                this.lastContent = content.isLast();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            HttpClient client = HttpSenderOverHTTP.this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            block8: while (true) {
                result = HttpSenderOverHTTP.this.generator.generateRequest(this.metaData, this.headerBuffer, this.chunkBuffer, this.contentBuffer, this.lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated headers ({} bytes), chunk ({} bytes), content ({} bytes) - {}/{}", new Object[]{this.headerBuffer == null ? -1 : this.headerBuffer.remaining(), this.chunkBuffer == null ? -1 : this.chunkBuffer.remaining(), this.contentBuffer == null ? -1 : this.contentBuffer.remaining(), result, HttpSenderOverHTTP.this.generator});
                }
                switch (result) {
                    case NEED_HEADER: {
                        this.headerBuffer = bufferPool.acquire(client.getRequestBufferSize(), false);
                        continue block8;
                    }
                    case NEED_CHUNK: {
                        this.chunkBuffer = bufferPool.acquire(12, false);
                        continue block8;
                    }
                    case FLUSH: {
                        EndPoint endPoint = HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (this.chunkBuffer == null) {
                            if (this.contentBuffer == null) {
                                endPoint.write(this, this.headerBuffer);
                            } else {
                                endPoint.write(this, this.headerBuffer, this.contentBuffer);
                            }
                        } else if (this.contentBuffer == null) {
                            endPoint.write(this, this.headerBuffer, this.chunkBuffer);
                        } else {
                            endPoint.write(this, this.headerBuffer, this.chunkBuffer, this.contentBuffer);
                        }
                        this.generated = true;
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpSenderOverHTTP.this.shutdownOutput();
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        if (this.generated) return IteratingCallback.Action.SUCCEEDED;
                        continue block8;
                    }
                    case DONE: {
                        if (!this.generated) throw new HttpRequestException("Could not generate headers", this.exchange.getRequest());
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                }
                break;
            }
            throw new IllegalStateException(result.toString());
        }

        @Override
        public void succeeded() {
            this.release();
            super.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            this.release();
            this.callback.failed(x);
            super.failed(x);
        }

        @Override
        protected void onCompleteSuccess() {
            super.onCompleteSuccess();
            this.callback.succeeded();
        }

        private void release() {
            HttpClient client = HttpSenderOverHTTP.this.getHttpChannel().getHttpDestination().getHttpClient();
            ByteBufferPool bufferPool = client.getByteBufferPool();
            bufferPool.release(this.headerBuffer);
            this.headerBuffer = null;
            if (this.chunkBuffer != null) {
                bufferPool.release(this.chunkBuffer);
            }
            this.chunkBuffer = null;
        }
    }
}

