/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser.JodaDeserializerBase;
import com.facebook.presto.jdbc.internal.joda.time.DateTimeZone;
import java.io.IOException;

public class DateTimeZoneDeserializer
extends JodaDeserializerBase<DateTimeZone> {
    private static final long serialVersionUID = 1L;

    public DateTimeZoneDeserializer() {
        super(DateTimeZone.class);
    }

    @Override
    public DateTimeZone deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return DateTimeZone.forOffsetHours(jp.getIntValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            return DateTimeZone.forID(jp.getText().trim());
        }
        throw ctxt.mappingException(DateTimeZone.class, JsonToken.VALUE_STRING);
    }
}

