/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser;

import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationFeature;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.datatype.joda.deser.JodaDeserializerBase;
import com.facebook.presto.jdbc.internal.joda.time.DateTime;
import com.facebook.presto.jdbc.internal.joda.time.DateTimeZone;
import com.facebook.presto.jdbc.internal.joda.time.ReadableDateTime;
import com.facebook.presto.jdbc.internal.joda.time.ReadableInstant;
import java.io.IOException;
import java.util.TimeZone;

public class DateTimeDeserializer
extends JodaDeserializerBase<ReadableInstant> {
    private static final long serialVersionUID = 1L;

    public DateTimeDeserializer(Class<? extends ReadableInstant> cls) {
        super(cls);
    }

    public static <T extends ReadableInstant> JsonDeserializer<T> forType(Class<T> cls) {
        return new DateTimeDeserializer((Class<? extends ReadableInstant>)cls);
    }

    @Override
    public ReadableDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        DateTimeZone dtz;
        JsonToken t = jp.getCurrentToken();
        TimeZone tz = ctxt.getTimeZone();
        DateTimeZone dateTimeZone = dtz = tz == null ? DateTimeZone.UTC : DateTimeZone.forTimeZone(tz);
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new DateTime(jp.getLongValue(), dtz);
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            if (ctxt.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE)) {
                return new DateTime((Object)str, dtz);
            }
            return DateTime.parse(str);
        }
        throw ctxt.mappingException(this.getValueClass());
    }
}

