/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser;

import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.BoundType;
import com.facebook.presto.jdbc.internal.guava.collect.Range;
import com.facebook.presto.jdbc.internal.jackson.core.JsonParser;
import com.facebook.presto.jdbc.internal.jackson.core.JsonProcessingException;
import com.facebook.presto.jdbc.internal.jackson.core.JsonToken;
import com.facebook.presto.jdbc.internal.jackson.databind.BeanProperty;
import com.facebook.presto.jdbc.internal.jackson.databind.DeserializationContext;
import com.facebook.presto.jdbc.internal.jackson.databind.JavaType;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.JsonMappingException;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.ContextualDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.deser.std.StdDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.jsontype.TypeDeserializer;
import com.facebook.presto.jdbc.internal.jackson.databind.type.TypeFactory;
import com.facebook.presto.jdbc.internal.jackson.datatype.guava.deser.util.RangeFactory;
import java.io.IOException;

public class RangeDeserializer
extends StdDeserializer<Range<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _rangeType;
    protected final JsonDeserializer<Object> _endpointDeserializer;

    public RangeDeserializer(JavaType rangeType) {
        this(rangeType, null);
    }

    public RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser) {
        super(rangeType);
        this._rangeType = rangeType;
        this._endpointDeserializer = endpointDeser;
    }

    @Override
    public JavaType getValueType() {
        return this._rangeType;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        if (this._endpointDeserializer == null) {
            JavaType endpointType = this._rangeType.containedType(0);
            if (endpointType == null) {
                endpointType = TypeFactory.unknownType();
            }
            JsonDeserializer<Object> deser = ctxt.findContextualValueDeserializer(endpointType, property);
            return new RangeDeserializer(this._rangeType, deser);
        }
        return this;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    @Override
    public Range<?> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = parser.nextToken();
        }
        Comparable<?> lowerEndpoint = null;
        Comparable<?> upperEndpoint = null;
        BoundType lowerBoundType = null;
        BoundType upperBoundType = null;
        while (t != JsonToken.END_OBJECT) {
            block13: {
                this.expect(parser, JsonToken.FIELD_NAME, t);
                String fieldName = parser.getCurrentName();
                try {
                    if (fieldName.equals("lowerEndpoint")) {
                        Preconditions.checkState(lowerEndpoint == null, "'lowerEndpoint' field included multiple times.");
                        parser.nextToken();
                        lowerEndpoint = this.deserializeEndpoint(parser, context);
                        break block13;
                    }
                    if (fieldName.equals("upperEndpoint")) {
                        Preconditions.checkState(upperEndpoint == null, "'upperEndpoint' field included multiple times.");
                        parser.nextToken();
                        upperEndpoint = this.deserializeEndpoint(parser, context);
                        break block13;
                    }
                    if (fieldName.equals("lowerBoundType")) {
                        Preconditions.checkState(lowerBoundType == null, "'lowerBoundType' field included multiple times.");
                        parser.nextToken();
                        lowerBoundType = this.deserializeBoundType(parser);
                        break block13;
                    }
                    if (fieldName.equals("upperBoundType")) {
                        Preconditions.checkState(upperBoundType == null, "'upperBoundType' field included multiple times.");
                        parser.nextToken();
                        upperBoundType = this.deserializeBoundType(parser);
                        break block13;
                    }
                    throw context.mappingException("Unexpected Range field: " + fieldName);
                }
                catch (IllegalStateException e) {
                    throw new JsonMappingException(e.getMessage());
                }
            }
            t = parser.nextToken();
        }
        try {
            if (lowerEndpoint != null && upperEndpoint != null) {
                Preconditions.checkState(lowerEndpoint.getClass() == upperEndpoint.getClass(), "Endpoint types are not the same - 'lowerEndpoint' deserialized to [%s], and 'upperEndpoint' deserialized to [%s].", lowerEndpoint.getClass().getName(), upperEndpoint.getClass().getName());
                Preconditions.checkState(lowerBoundType != null, "'lowerEndpoint' field found, but not 'lowerBoundType'");
                Preconditions.checkState(upperBoundType != null, "'upperEndpoint' field found, but not 'upperBoundType'");
                return RangeFactory.range(lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType);
            }
            if (lowerEndpoint != null) {
                Preconditions.checkState(lowerBoundType != null, "'lowerEndpoint' field found, but not 'lowerBoundType'");
                return RangeFactory.downTo(lowerEndpoint, lowerBoundType);
            }
            if (upperEndpoint != null) {
                Preconditions.checkState(upperBoundType != null, "'upperEndpoint' field found, but not 'upperBoundType'");
                return RangeFactory.upTo(upperEndpoint, upperBoundType);
            }
            return RangeFactory.all();
        }
        catch (IllegalStateException e) {
            throw new JsonMappingException(e.getMessage());
        }
    }

    private BoundType deserializeBoundType(JsonParser parser) throws IOException {
        this.expect(parser, JsonToken.VALUE_STRING, parser.getCurrentToken());
        String name = parser.getText();
        try {
            return BoundType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("[" + name + "] is not a valid BoundType name.");
        }
    }

    private Comparable<?> deserializeEndpoint(JsonParser parser, DeserializationContext context) throws IOException {
        Object obj = this._endpointDeserializer.deserialize(parser, context);
        if (!(obj instanceof Comparable)) {
            throw context.mappingException(String.format("Field [%s] deserialized to [%s], which does not implement Comparable.", parser.getCurrentName(), obj.getClass().getName()));
        }
        return (Comparable)obj;
    }

    private void expect(JsonParser jp, JsonToken expected, JsonToken actual) throws JsonMappingException {
        if (actual != expected) {
            throw new JsonMappingException("Expecting " + (Object)((Object)expected) + ", found " + (Object)((Object)actual), jp.getCurrentLocation());
        }
    }
}

