/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import java.util.Objects;

public class PrestoIntervalDayTime {
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private final long milliSeconds;

    public PrestoIntervalDayTime(long milliSeconds) {
        this.milliSeconds = milliSeconds;
    }

    public PrestoIntervalDayTime(int day, int hour, int minute, int second, int millis) {
        this.milliSeconds = PrestoIntervalDayTime.toMillis(day, hour, minute, second, millis);
    }

    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    public int hashCode() {
        return Objects.hash(this.milliSeconds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoIntervalDayTime other = (PrestoIntervalDayTime)obj;
        return Objects.equals(this.milliSeconds, other.milliSeconds);
    }

    public String toString() {
        return PrestoIntervalDayTime.formatMillis(this.milliSeconds);
    }

    private static long toMillis(int day, int hour, int minute, int second, int millis) {
        return (long)day * 86400000L + (long)hour * 3600000L + (long)minute * 60000L + (long)second * 1000L + (long)millis;
    }

    private static String formatMillis(long millis) {
        long day = millis / 86400000L;
        long hour = (millis %= 86400000L) / 3600000L;
        long minute = (millis %= 3600000L) / 60000L;
        long second = (millis %= 60000L) / 1000L;
        return String.format("%d %02d:%02d:%02d.%03d", day, hour, minute, second, millis %= 1000L);
    }
}

