/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.session;

import com.facebook.presto.jdbc.internal.spi.type.BigintType;
import com.facebook.presto.jdbc.internal.spi.type.BooleanType;
import com.facebook.presto.jdbc.internal.spi.type.DoubleType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.VarcharType;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;

public final class PropertyMetadata<T> {
    private final String name;
    private final String description;
    private final Type sqlType;
    private final Class<T> javaType;
    private final T defaultValue;
    private final boolean hidden;
    private final Function<Object, T> decoder;

    public PropertyMetadata(String name, String description, Type sqlType, Class<T> javaType, T defaultValue, boolean hidden) {
        this(name, description, sqlType, javaType, defaultValue, hidden, javaType::cast);
    }

    public PropertyMetadata(String name, String description, Type sqlType, Class<T> javaType, T defaultValue, boolean hidden, Function<Object, T> decoder) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(description, "description is null");
        Objects.requireNonNull(sqlType, "type is null");
        Objects.requireNonNull(javaType, "javaType is null");
        Objects.requireNonNull(decoder, "decoder is null");
        if (name.isEmpty() || !name.trim().toLowerCase(Locale.ENGLISH).equals(name)) {
            throw new IllegalArgumentException(String.format("Invalid session property name '%s'", name));
        }
        if (description.isEmpty() || !description.trim().equals(description)) {
            throw new IllegalArgumentException(String.format("Invalid session property description '%s'", description));
        }
        this.name = name;
        this.description = description;
        this.javaType = javaType;
        this.sqlType = sqlType;
        this.defaultValue = defaultValue;
        this.hidden = hidden;
        this.decoder = decoder;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Type getSqlType() {
        return this.sqlType;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public T decode(Object value) {
        return this.decoder.apply(value);
    }

    public static PropertyMetadata<Boolean> booleanSessionProperty(String name, String description, Boolean defaultValue, boolean hidden) {
        return new PropertyMetadata<Boolean>(name, description, BooleanType.BOOLEAN, Boolean.class, defaultValue, hidden, Boolean.class::cast);
    }

    public static PropertyMetadata<Integer> integerSessionProperty(String name, String description, Integer defaultValue, boolean hidden) {
        return new PropertyMetadata<Integer>(name, description, BigintType.BIGINT, Integer.class, defaultValue, hidden, value -> ((Number)value).intValue());
    }

    public static PropertyMetadata<Long> longSessionProperty(String name, String description, Long defaultValue, boolean hidden) {
        return new PropertyMetadata<Long>(name, description, BigintType.BIGINT, Long.class, defaultValue, hidden, value -> ((Number)value).longValue());
    }

    public static PropertyMetadata<Double> doubleSessionProperty(String name, String description, Double defaultValue, boolean hidden) {
        return new PropertyMetadata<Double>(name, description, DoubleType.DOUBLE, Double.class, defaultValue, hidden, value -> ((Number)value).doubleValue());
    }

    public static PropertyMetadata<String> stringSessionProperty(String name, String description, String defaultValue, boolean hidden) {
        return new PropertyMetadata<String>(name, description, VarcharType.VARCHAR, String.class, defaultValue, hidden, String.class::cast);
    }
}

