/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.LazyBlockLoader;
import java.util.Objects;

public class LazyArrayBlock
extends AbstractArrayBlock {
    private Block values;
    private Slice offsets;
    private Slice valueIsNull;
    private int offsetBase = -1;
    private LazyBlockLoader<LazyArrayBlock> loader;

    public LazyArrayBlock(LazyBlockLoader<LazyArrayBlock> loader) {
        this.loader = Objects.requireNonNull(loader);
    }

    @Override
    public int getPositionCount() {
        this.assureLoaded();
        return this.valueIsNull.length();
    }

    @Override
    protected Block getValues() {
        this.assureLoaded();
        return this.values;
    }

    @Override
    protected Slice getOffsets() {
        this.assureLoaded();
        return this.offsets;
    }

    @Override
    protected int getOffsetBase() {
        this.assureLoaded();
        return this.offsetBase;
    }

    @Override
    protected Slice getValueIsNull() {
        this.assureLoaded();
        return this.valueIsNull;
    }

    @Override
    public void assureLoaded() {
        if (this.loader == null) {
            return;
        }
        this.loader.load(this);
        if (this.values == null || this.offsets == null || this.valueIsNull == null || this.offsetBase < 0) {
            throw new IllegalArgumentException("Lazy block loader did not load this block");
        }
        this.loader = null;
    }

    public void copyFromBlock(Block block) {
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        this.values = arrayBlock.getValues();
        this.offsets = arrayBlock.getOffsets();
        this.offsetBase = arrayBlock.getOffsetBase();
        this.valueIsNull = arrayBlock.getValueIsNull();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LazyArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append(", loaded=").append(this.loader == null);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int getSizeInBytes() {
        if (this.loader != null) {
            return 4;
        }
        return super.getSizeInBytes();
    }

    @Override
    public int getRetainedSizeInBytes() {
        if (this.loader != null) {
            return 4;
        }
        return super.getSizeInBytes();
    }
}

