/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingFactory;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;
import java.util.Objects;

public class DictionaryBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<DictionaryBlockEncoding> FACTORY = new DictionaryBlockEncodingFactory();
    private static final String NAME = "DICTIONARY";
    private final BlockEncoding dictionaryEncoding;

    public DictionaryBlockEncoding(BlockEncoding dictionaryEncoding) {
        this.dictionaryEncoding = Objects.requireNonNull(dictionaryEncoding, "dictionaryEncoding is null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
        dictionaryBlock = dictionaryBlock.compact();
        int positionCount = dictionaryBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        Block dictionary = dictionaryBlock.getDictionary();
        this.dictionaryEncoding.writeBlock(sliceOutput, dictionary);
        Slice ids = dictionaryBlock.getIds();
        sliceOutput.appendInt(ids.length()).writeBytes(ids);
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        Block dictionaryBlock = this.dictionaryEncoding.readBlock(sliceInput);
        int lengthIdsSlice = sliceInput.readInt();
        Slice ids = sliceInput.readSlice(lengthIdsSlice);
        return new DictionaryBlock(positionCount, dictionaryBlock, ids);
    }

    @Override
    public int getEstimatedSize(Block block) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    public BlockEncoding getDictionaryEncoding() {
        return this.dictionaryEncoding;
    }

    public static class DictionaryBlockEncodingFactory
    implements BlockEncodingFactory<DictionaryBlockEncoding> {
        @Override
        public String getName() {
            return DictionaryBlockEncoding.NAME;
        }

        @Override
        public DictionaryBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            BlockEncoding dictionaryEncoding = serde.readBlockEncoding(input);
            return new DictionaryBlockEncoding(dictionaryEncoding);
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, DictionaryBlockEncoding blockEncoding) {
            serde.writeBlockEncoding(output, blockEncoding.getDictionaryEncoding());
        }
    }
}

