/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.ConstantProperty;
import com.facebook.presto.jdbc.internal.spi.LocalProperty;
import com.facebook.presto.jdbc.internal.spi.block.SortOrder;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class SortingProperty<E>
implements LocalProperty<E> {
    private final E column;
    private final SortOrder order;

    public SortingProperty(E column, SortOrder order) {
        Objects.requireNonNull(column, "column is null");
        Objects.requireNonNull(order, "order is null");
        this.column = column;
        this.order = order;
    }

    public E getColumn() {
        return this.column;
    }

    @Override
    public Set<E> getColumns() {
        return Collections.singleton(this.column);
    }

    public SortOrder getOrder() {
        return this.order;
    }

    @Override
    public <T> Optional<LocalProperty<T>> translate(Function<E, Optional<T>> translator) {
        Optional<T> translated = translator.apply(this.column);
        if (translated.isPresent()) {
            return Optional.of(new SortingProperty<T>(translated.get(), this.order));
        }
        return Optional.empty();
    }

    @Override
    public boolean isSimplifiedBy(LocalProperty<E> known) {
        return known instanceof ConstantProperty || known.equals(this);
    }

    public String toString() {
        String ordering = "";
        String nullOrdering = "";
        switch (this.order) {
            case ASC_NULLS_FIRST: {
                ordering = "\u2191";
                nullOrdering = "\u2190";
                break;
            }
            case ASC_NULLS_LAST: {
                ordering = "\u2191";
                nullOrdering = "\u2190";
                break;
            }
            case DESC_NULLS_FIRST: {
                ordering = "\u2193";
                nullOrdering = "\u2192";
                break;
            }
            case DESC_NULLS_LAST: {
                ordering = "\u2193";
                nullOrdering = "\u2192";
            }
        }
        return "S" + ordering + nullOrdering + "(" + this.column + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortingProperty that = (SortingProperty)o;
        return Objects.equals(this.column, that.column) && Objects.equals((Object)this.order, (Object)that.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.column, this.order});
    }
}

