/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.jdbc.internal.spi.LocalProperty;
import com.facebook.presto.jdbc.internal.spi.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ConnectorTableLayout {
    private final ConnectorTableLayoutHandle handle;
    private final Optional<List<ColumnHandle>> columns;
    private final TupleDomain<ColumnHandle> predicate;
    private final Optional<List<TupleDomain<ColumnHandle>>> discretePredicates;
    private final Optional<Set<ColumnHandle>> partitioningColumns;
    private final List<LocalProperty<ColumnHandle>> localProperties;

    public ConnectorTableLayout(ConnectorTableLayoutHandle handle, Optional<List<ColumnHandle>> columns, TupleDomain<ColumnHandle> predicate, Optional<Set<ColumnHandle>> partitioningColumns, Optional<List<TupleDomain<ColumnHandle>>> discretePredicates, List<LocalProperty<ColumnHandle>> localProperties) {
        Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(partitioningColumns, "partitioningColumns is null");
        Objects.requireNonNull(predicate, "predicate is null");
        Objects.requireNonNull(discretePredicates, "discretePredicates is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        this.handle = handle;
        this.columns = columns;
        this.partitioningColumns = partitioningColumns;
        this.predicate = predicate;
        this.discretePredicates = discretePredicates;
        this.localProperties = localProperties;
    }

    public ConnectorTableLayoutHandle getHandle() {
        return this.handle;
    }

    public Optional<List<ColumnHandle>> getColumns() {
        return this.columns;
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.predicate;
    }

    public Optional<Set<ColumnHandle>> getPartitioningColumns() {
        return this.partitioningColumns;
    }

    public Optional<List<TupleDomain<ColumnHandle>>> getDiscretePredicates() {
        return this.discretePredicates;
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.localProperties;
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.columns, this.predicate, this.discretePredicates, this.partitioningColumns, this.localProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorTableLayout other = (ConnectorTableLayout)obj;
        return Objects.equals(this.handle, other.handle) && Objects.equals(this.columns, other.columns) && Objects.equals(this.predicate, other.predicate) && Objects.equals(this.discretePredicates, other.discretePredicates) && Objects.equals(this.partitioningColumns, other.partitioningColumns) && Objects.equals(this.localProperties, other.localProperties);
    }
}

