/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.ColumnMetadata;
import com.facebook.presto.jdbc.internal.spi.ConnectorInsertTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorOutputTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayout;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableLayoutResult;
import com.facebook.presto.jdbc.internal.spi.ConnectorTableMetadata;
import com.facebook.presto.jdbc.internal.spi.Constraint;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.SchemaTableName;
import com.facebook.presto.jdbc.internal.spi.SchemaTablePrefix;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ConnectorMetadata {
    public List<String> listSchemaNames(ConnectorSession var1);

    public ConnectorTableHandle getTableHandle(ConnectorSession var1, SchemaTableName var2);

    default public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    default public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession var1, ConnectorTableHandle var2);

    public List<SchemaTableName> listTables(ConnectorSession var1, String var2);

    public ColumnHandle getSampleWeightColumnHandle(ConnectorSession var1, ConnectorTableHandle var2);

    public boolean canCreateSampledTables(ConnectorSession var1);

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession var1, ConnectorTableHandle var2);

    public ColumnMetadata getColumnMetadata(ConnectorSession var1, ConnectorTableHandle var2, ColumnHandle var3);

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession var1, SchemaTablePrefix var2);

    public void createTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void dropTable(ConnectorSession var1, ConnectorTableHandle var2);

    public void renameTable(ConnectorSession var1, ConnectorTableHandle var2, SchemaTableName var3);

    default public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming columns");
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession var1, ConnectorTableMetadata var2);

    public void commitCreateTable(ConnectorSession var1, ConnectorOutputTableHandle var2, Collection<Slice> var3);

    default public void rollbackCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession var1, ConnectorTableHandle var2);

    public void commitInsert(ConnectorSession var1, ConnectorInsertTableHandle var2, Collection<Slice> var3);

    default public void rollbackInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle) {
    }

    default public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support updates or deletes");
    }

    default public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    default public void commitDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support deletes");
    }

    default public void rollbackDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
    }

    public void createView(ConnectorSession var1, SchemaTableName var2, String var3, boolean var4);

    public void dropView(ConnectorSession var1, SchemaTableName var2);

    public List<SchemaTableName> listViews(ConnectorSession var1, String var2);

    public Map<SchemaTableName, String> getViews(ConnectorSession var1, SchemaTablePrefix var2);
}

