/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.airlift.concurrent;

import com.facebook.presto.jdbc.internal.airlift.log.Logger;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class BoundedExecutor
implements Executor {
    private static final Logger log = Logger.get(BoundedExecutor.class);
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private final Runnable triggerTask = new Runnable(){

        @Override
        public void run() {
            BoundedExecutor.this.executeOrMerge();
        }
    };
    private final Executor coreExecutor;
    private final int maxThreads;

    public BoundedExecutor(Executor coreExecutor, int maxThreads) {
        Preconditions.checkNotNull(coreExecutor, "coreExecutor is null");
        Preconditions.checkArgument(maxThreads > 0, "maxThreads must be greater than zero");
        this.coreExecutor = coreExecutor;
        this.maxThreads = maxThreads;
    }

    @Override
    public void execute(Runnable task) {
        this.queue.add(task);
        this.coreExecutor.execute(this.triggerTask);
    }

    private void executeOrMerge() {
        int size = this.queueSize.incrementAndGet();
        if (size <= this.maxThreads) {
            do {
                try {
                    this.queue.poll().run();
                }
                catch (Throwable e) {
                    log.error(e, "Task failed");
                }
            } while (this.queueSize.getAndDecrement() > this.maxThreads);
        }
    }
}

