/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.UserAgentRequestFilter;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.HttpClientConfig;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyHttpClient;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPool;
import com.facebook.presto.jdbc.internal.airlift.http.client.jetty.JettyIoPoolConfig;
import com.facebook.presto.jdbc.internal.airlift.json.JsonCodec;
import com.facebook.presto.jdbc.internal.airlift.units.Duration;
import com.facebook.presto.jdbc.internal.client.ClientSession;
import com.facebook.presto.jdbc.internal.client.QueryResults;
import com.facebook.presto.jdbc.internal.client.StatementClient;
import com.facebook.presto.jdbc.internal.guava.base.Preconditions;
import com.facebook.presto.jdbc.internal.guava.collect.ImmutableSet;
import com.facebook.presto.jdbc.internal.guava.net.HostAndPort;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class QueryExecutor
implements Closeable {
    private final JsonCodec<QueryResults> queryInfoCodec;
    private final HttpClient httpClient;

    private QueryExecutor(String userAgent, JsonCodec<QueryResults> queryResultsCodec, HostAndPort socksProxy) {
        Preconditions.checkNotNull(userAgent, "userAgent is null");
        Preconditions.checkNotNull(queryResultsCodec, "queryResultsCodec is null");
        this.queryInfoCodec = queryResultsCodec;
        this.httpClient = new JettyHttpClient(new HttpClientConfig().setConnectTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSocksProxy(socksProxy), new JettyIoPool("presto-jdbc", new JettyIoPoolConfig()), ImmutableSet.of(new UserAgentRequestFilter(userAgent)));
    }

    public StatementClient startQuery(ClientSession session, String query) {
        return new StatementClient(this.httpClient, this.queryInfoCodec, session, query);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    protected void finalize() {
        this.close();
    }

    static QueryExecutor create(String userAgent) {
        return new QueryExecutor(userAgent, JsonCodec.jsonCodec(QueryResults.class), QueryExecutor.getSystemSocksProxy());
    }

    @Nullable
    private static HostAndPort getSystemSocksProxy() {
        URI uri = URI.create("socket://0.0.0.0:80");
        for (Proxy proxy : ProxySelector.getDefault().select(uri)) {
            if (proxy.type() != Proxy.Type.SOCKS || !(proxy.address() instanceof InetSocketAddress)) continue;
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            return HostAndPort.fromParts(address.getHostString(), address.getPort());
        }
        return null;
    }
}

