/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.JettyLogging;
import com.facebook.presto.jdbc.PrestoConnection;
import com.facebook.presto.jdbc.QueryExecutor;
import com.facebook.presto.jdbc.internal.guava.base.Strings;
import com.facebook.presto.jdbc.internal.guava.base.Throwables;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class PrestoDriver
implements Driver,
Closeable {
    static final int VERSION_MAJOR = 1;
    static final int VERSION_MINOR = 0;
    static final int JDBC_VERSION_MAJOR = 4;
    static final int JDBC_VERSION_MINOR = 1;
    static final String DRIVER_NAME = "Presto JDBC Driver";
    static final String DRIVER_VERSION = "1.0";
    private static final DriverPropertyInfo[] DRIVER_PROPERTY_INFOS = new DriverPropertyInfo[0];
    private static final String JDBC_URL_START = "jdbc:";
    private static final String DRIVER_URL_START = "jdbc:presto:";
    private static final String USER_PROPERTY = "user";
    private final QueryExecutor queryExecutor = QueryExecutor.create("Presto JDBC Driver/1.0");

    @Override
    public void close() {
        this.queryExecutor.close();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String user = info.getProperty(USER_PROPERTY);
        if (Strings.isNullOrEmpty(user)) {
            throw new SQLException(String.format("Username property (%s) must be set", USER_PROPERTY));
        }
        return new PrestoConnection(PrestoDriver.parseDriverUrl(url), user, this.queryExecutor);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(DRIVER_URL_START);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return DRIVER_PROPERTY_INFOS;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private static URI parseDriverUrl(String url) throws SQLException {
        URI uri;
        try {
            uri = new URI(url.substring(JDBC_URL_START.length()));
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid JDBC URL: " + url, e);
        }
        if (Strings.isNullOrEmpty(uri.getHost())) {
            throw new SQLException("No host specified: " + url);
        }
        if (uri.getPort() == -1) {
            throw new SQLException("No port number specified: " + url);
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException("Invalid port number: " + url);
        }
        return uri;
    }

    static {
        JettyLogging.useJavaUtilLogging();
        try {
            DriverManager.registerDriver(new PrestoDriver());
        }
        catch (SQLException e) {
            throw Throwables.propagate(e);
        }
    }
}

