/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg.optimizer;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class IcebergPlanOptimizer
implements ConnectorPlanOptimizer {
    private final RowExpressionService rowExpressionService;
    private final StandardFunctionResolution functionResolution;
    private final TypeManager typeManager;

    @Inject
    IcebergPlanOptimizer(StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, TypeManager typeManager) {
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        return ConnectorPlanRewriter.rewriteWith((ConnectorPlanRewriter)new FilterPushdownRewriter(this.functionResolution, this.rowExpressionService, this.typeManager, idAllocator, session), (PlanNode)maxSubplan);
    }

    private static class FilterPushdownRewriter
    extends ConnectorPlanRewriter<Void> {
        private final ConnectorSession session;
        private final RowExpressionService rowExpressionService;
        private final StandardFunctionResolution functionResolution;
        private final TypeManager typeManager;
        private final PlanNodeIdAllocator idAllocator;

        public FilterPushdownRewriter(StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService, TypeManager typeManager, PlanNodeIdAllocator idAllocator, ConnectorSession session) {
            this.functionResolution = functionResolution;
            this.rowExpressionService = rowExpressionService;
            this.typeManager = typeManager;
            this.idAllocator = idAllocator;
            this.session = session;
        }

        public PlanNode visitFilter(FilterNode filter, ConnectorPlanRewriter.RewriteContext<Void> context) {
            if (!(filter.getSource() instanceof TableScanNode)) {
                return this.visitPlan((PlanNode)filter, context);
            }
            TableScanNode tableScan = (TableScanNode)filter.getSource();
            Map<String, IcebergColumnHandle> nameToColumnHandlesMapping = tableScan.getAssignments().entrySet().stream().collect(Collectors.toMap(e -> ((VariableReferenceExpression)e.getKey()).getName(), e -> (IcebergColumnHandle)e.getValue()));
            RowExpression filterPredicate = filter.getPredicate();
            DomainTranslator.ExtractionResult decomposedFilter = this.rowExpressionService.getDomainTranslator().fromPredicate(this.session, filterPredicate, new SubfieldExtractor(this.functionResolution, this.rowExpressionService.getExpressionOptimizer(), this.session).toColumnExtractor());
            TupleDomain entireColumnDomain = decomposedFilter.getTupleDomain().transform(subfield -> subfield.getPath().isEmpty() ? subfield.getRootName() : null).transform(nameToColumnHandlesMapping::get);
            TupleDomain simplifiedColumnDomain = entireColumnDomain.simplify();
            TableHandle handle = tableScan.getTable();
            IcebergTableHandle oldTableHandle = (IcebergTableHandle)handle.getConnectorHandle();
            IcebergTableHandle newTableHandle = new IcebergTableHandle(oldTableHandle.getSchemaName(), oldTableHandle.getTableName(), oldTableHandle.getTableType(), oldTableHandle.getSnapshotId(), (TupleDomain<IcebergColumnHandle>)simplifiedColumnDomain);
            TableScanNode newTableScan = new TableScanNode(tableScan.getSourceLocation(), tableScan.getId(), new TableHandle(handle.getConnectorId(), (ConnectorTableHandle)newTableHandle, handle.getTransaction(), handle.getLayout()), tableScan.getOutputVariables(), tableScan.getAssignments(), tableScan.getCurrentConstraint(), TupleDomain.all());
            if (LogicalRowExpressions.TRUE_CONSTANT.equals((Object)filterPredicate)) {
                return newTableScan;
            }
            return new FilterNode(filter.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)newTableScan, filterPredicate);
        }
    }
}

