/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.iceberg.ExpressionConverter;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.Partition;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.DoubleRange;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class TableStatisticsMaker {
    private final TypeManager typeManager;
    private final Table icebergTable;

    private TableStatisticsMaker(TypeManager typeManager, Table icebergTable) {
        this.typeManager = typeManager;
        this.icebergTable = icebergTable;
    }

    public static TableStatistics getTableStatistics(TypeManager typeManager, Constraint constraint, IcebergTableHandle tableHandle, Table icebergTable) {
        return new TableStatisticsMaker(typeManager, icebergTable).makeTableStatistics(tableHandle, constraint);
    }

    private TableStatistics makeTableStatistics(IcebergTableHandle tableHandle, Constraint constraint) {
        if (!tableHandle.getSnapshotId().isPresent() || constraint.getSummary().isNone()) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        TupleDomain intersection = constraint.getSummary().transform(IcebergColumnHandle.class::cast).intersect(tableHandle.getPredicate());
        if (intersection.isNone()) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        List columns = this.icebergTable.schema().columns();
        Map<Integer, Type.PrimitiveType> idToTypeMapping = columns.stream().filter(column -> column.type().isPrimitiveType()).collect(Collectors.toMap(Types.NestedField::fieldId, column -> column.type().asPrimitiveType()));
        List partitionFields = this.icebergTable.spec().fields();
        Set identityPartitionIds = IcebergUtil.getIdentityPartitions(this.icebergTable.spec()).keySet().stream().map(PartitionField::sourceId).collect(Collectors.toSet());
        List nonPartitionPrimitiveColumns = (List)columns.stream().filter(column -> !identityPartitionIds.contains(column.fieldId()) && column.type().isPrimitiveType()).collect(ImmutableList.toImmutableList());
        List<Type> icebergPartitionTypes = this.partitionTypes(partitionFields, idToTypeMapping);
        List<IcebergColumnHandle> columnHandles = IcebergUtil.getColumns(this.icebergTable.schema(), this.typeManager);
        Map idToColumnHandle = (Map)columnHandles.stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getId, Function.identity()));
        ImmutableMap.Builder idToDetailsBuilder = ImmutableMap.builder();
        for (int index = 0; index < partitionFields.size(); ++index) {
            PartitionField field = (PartitionField)partitionFields.get(index);
            Type type = icebergPartitionTypes.get(index);
            idToDetailsBuilder.put((Object)field.sourceId(), (Object)new ColumnFieldDetails(field, (IcebergColumnHandle)idToColumnHandle.get(field.sourceId()), type, TypeConverter.toPrestoType(type, this.typeManager), type.typeId().javaClass()));
        }
        ImmutableMap idToDetails = idToDetailsBuilder.build();
        TableScan tableScan = (TableScan)((TableScan)this.icebergTable.newScan().filter(ExpressionConverter.toIcebergExpression((TupleDomain<IcebergColumnHandle>)intersection))).useSnapshot(tableHandle.getSnapshotId().get().longValue()).includeColumnStats();
        Partition summary = null;
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            for (FileScanTask fileScanTask : fileScanTasks) {
                DataFile dataFile = (DataFile)fileScanTask.file();
                if (!this.dataFileMatches(dataFile, constraint, idToTypeMapping, partitionFields, (Map<Integer, ColumnFieldDetails>)idToDetails)) continue;
                if (summary == null) {
                    summary = new Partition(idToTypeMapping, nonPartitionPrimitiveColumns, dataFile.partition(), dataFile.recordCount(), dataFile.fileSizeInBytes(), Partition.toMap(idToTypeMapping, dataFile.lowerBounds()), Partition.toMap(idToTypeMapping, dataFile.upperBounds()), dataFile.nullValueCounts(), dataFile.columnSizes());
                    continue;
                }
                summary.incrementFileCount();
                summary.incrementRecordCount(dataFile.recordCount());
                summary.incrementSize(dataFile.fileSizeInBytes());
                this.updateSummaryMin(summary, partitionFields, Partition.toMap(idToTypeMapping, dataFile.lowerBounds()), dataFile.nullValueCounts(), dataFile.recordCount());
                this.updateSummaryMax(summary, partitionFields, Partition.toMap(idToTypeMapping, dataFile.upperBounds()), dataFile.nullValueCounts(), dataFile.recordCount());
                summary.updateNullCount(dataFile.nullValueCounts());
                this.updateColumnSizes(summary, dataFile.columnSizes());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (summary == null) {
            return TableStatistics.builder().setRowCount(Estimate.of((double)0.0)).build();
        }
        double recordCount = summary.getRecordCount();
        TableStatistics.Builder result = TableStatistics.builder();
        result.setRowCount(Estimate.of((double)recordCount));
        result.setTotalSize(Estimate.of((double)summary.getSize()));
        for (IcebergColumnHandle columnHandle : idToColumnHandle.values()) {
            Long columnSize;
            int fieldId = columnHandle.getId();
            ColumnStatistics.Builder columnBuilder = new ColumnStatistics.Builder();
            Long nullCount = summary.getNullCounts().get(fieldId);
            if (nullCount != null) {
                columnBuilder.setNullsFraction(Estimate.of((double)((double)nullCount.longValue() / recordCount)));
            }
            if (summary.getColumnSizes() != null && (columnSize = summary.getColumnSizes().get(fieldId)) != null) {
                columnBuilder.setDataSize(Estimate.of((double)columnSize.longValue()));
            }
            Object min = summary.getMinValues().get(fieldId);
            Object max = summary.getMaxValues().get(fieldId);
            if (min instanceof Number && max instanceof Number) {
                columnBuilder.setRange(Optional.of(new DoubleRange(((Number)min).doubleValue(), ((Number)max).doubleValue())));
            }
            result.setColumnStatistics((ColumnHandle)columnHandle, columnBuilder.build());
        }
        return result.build();
    }

    private boolean dataFileMatches(DataFile dataFile, Constraint constraint, Map<Integer, Type.PrimitiveType> idToTypeMapping, List<PartitionField> partitionFields, Map<Integer, ColumnFieldDetails> fieldDetails) {
        return true;
    }

    private NullableValue makeNullableValue(com.facebook.presto.common.type.Type type, Object value) {
        return value == null ? NullableValue.asNull((com.facebook.presto.common.type.Type)type) : NullableValue.of((com.facebook.presto.common.type.Type)type, (Object)value);
    }

    public List<Type> partitionTypes(List<PartitionField> partitionFields, Map<Integer, Type.PrimitiveType> idToTypeMapping) {
        ImmutableList.Builder partitionTypeBuilder = ImmutableList.builder();
        for (PartitionField partitionField : partitionFields) {
            Type.PrimitiveType sourceType = idToTypeMapping.get(partitionField.sourceId());
            Type type = partitionField.transform().getResultType((Type)sourceType);
            partitionTypeBuilder.add((Object)type);
        }
        return partitionTypeBuilder.build();
    }

    public void updateColumnSizes(Partition summary, Map<Integer, Long> addedColumnSizes) {
        Map<Integer, Long> columnSizes = summary.getColumnSizes();
        if (!summary.hasValidColumnMetrics() || columnSizes == null || addedColumnSizes == null) {
            return;
        }
        for (Types.NestedField column : summary.getNonPartitionPrimitiveColumns()) {
            int id = column.fieldId();
            Long addedSize = addedColumnSizes.get(id);
            if (addedSize == null) continue;
            columnSizes.put(id, addedSize + columnSizes.getOrDefault(id, 0L));
        }
    }

    private void updateSummaryMin(Partition summary, List<PartitionField> partitionFields, Map<Integer, Object> lowerBounds, Map<Integer, Long> nullCounts, long recordCount) {
        summary.updateStats(summary.getMinValues(), lowerBounds, nullCounts, recordCount, i -> i > 0);
        this.updatePartitionedStats(summary, partitionFields, summary.getMinValues(), lowerBounds, i -> i > 0);
    }

    private void updateSummaryMax(Partition summary, List<PartitionField> partitionFields, Map<Integer, Object> upperBounds, Map<Integer, Long> nullCounts, long recordCount) {
        summary.updateStats(summary.getMaxValues(), upperBounds, nullCounts, recordCount, i -> i < 0);
        this.updatePartitionedStats(summary, partitionFields, summary.getMaxValues(), upperBounds, i -> i < 0);
    }

    private void updatePartitionedStats(Partition summary, List<PartitionField> partitionFields, Map<Integer, Object> current, Map<Integer, Object> newStats, Predicate<Integer> predicate) {
        for (PartitionField field : partitionFields) {
            Comparator comparator;
            Object oldValue;
            Object newValue;
            int id = field.sourceId();
            if (summary.getCorruptedStats().contains(id) || (newValue = newStats.get(id)) == null || (oldValue = current.putIfAbsent(id, newValue)) == null || !predicate.test((comparator = Comparators.forType((Type.PrimitiveType)summary.getIdToTypeMapping().get(id))).compare(oldValue, newValue))) continue;
            current.put(id, newValue);
        }
    }

    private static class ColumnFieldDetails {
        private final PartitionField field;
        private final IcebergColumnHandle columnHandle;
        private final Type icebergType;
        private final com.facebook.presto.common.type.Type prestoType;
        private final Class<?> javaClass;

        public ColumnFieldDetails(PartitionField field, IcebergColumnHandle columnHandle, Type icebergType, com.facebook.presto.common.type.Type prestoType, Class<?> javaClass) {
            this.field = Objects.requireNonNull(field, "field is null");
            this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.icebergType = Objects.requireNonNull(icebergType, "icebergType is null");
            this.prestoType = Objects.requireNonNull(prestoType, "prestoType is null");
            this.javaClass = Objects.requireNonNull(javaClass, "javaClass is null");
        }

        public PartitionField getField() {
            return this.field;
        }

        public IcebergColumnHandle getColumnHandle() {
            return this.columnHandle;
        }

        public Type getIcebergType() {
            return this.icebergType;
        }

        public com.facebook.presto.common.type.Type getPrestoType() {
            return this.prestoType;
        }

        public Class<?> getJavaClass() {
            return this.javaClass;
        }
    }
}

