/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.iceberg.TableType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IcebergTableName {
    private static final Pattern TABLE_PATTERN = Pattern.compile("(?<table>[^$@]+)(?:@(?<ver1>[0-9]+))?(?:\\$(?<type>[^@]+)(?:@(?<ver2>[0-9]+))?)?");
    private final String tableName;
    private final TableType tableType;
    private final Optional<Long> snapshotId;

    public IcebergTableName(String tableName, TableType tableType, Optional<Long> snapshotId) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableType = Objects.requireNonNull(tableType, "tableType is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public Optional<Long> getSnapshotId() {
        return this.snapshotId;
    }

    public String getTableNameWithType() {
        return this.tableName + "$" + this.tableType.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.getTableNameWithType() + "@" + this.snapshotId;
    }

    public static IcebergTableName from(String name) {
        Matcher match = TABLE_PATTERN.matcher(name);
        if (!match.matches()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name: " + name);
        }
        String table = match.group("table");
        String typeString = match.group("type");
        String version1 = match.group("ver1");
        String version2 = match.group("ver2");
        TableType type = TableType.DATA;
        if (typeString != null) {
            try {
                type = TableType.valueOf(typeString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Iceberg table name (unknown type '%s'): %s", typeString, name));
            }
        }
        Optional<Long> version = Optional.empty();
        if (type == TableType.DATA || type == TableType.PARTITIONS || type == TableType.MANIFESTS || type == TableType.FILES) {
            if (version1 != null && version2 != null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid Iceberg table name (cannot specify two @ versions): " + name);
            }
            if (version1 != null) {
                version = Optional.of(Long.parseLong(version1));
            } else if (version2 != null) {
                version = Optional.of(Long.parseLong(version2));
            }
        } else if (version1 != null || version2 != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Invalid Iceberg table name (cannot use @ version with table type '%s'): %s", new Object[]{type, name}));
        }
        return new IcebergTableName(table, type, version);
    }
}

