/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.ExpressionConverter;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.IcebergHiveMetadata;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergSplitSource;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableLayoutHandle;
import com.facebook.presto.iceberg.IcebergTransactionManager;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.util.TableScanUtil;

public class IcebergSplitManager
implements ConnectorSplitManager {
    private final IcebergTransactionManager transactionManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final IcebergResourceFactory resourceFactory;
    private final CatalogType catalogType;

    @Inject
    public IcebergSplitManager(IcebergConfig config, IcebergResourceFactory resourceFactory, IcebergTransactionManager transactionManager, HdfsEnvironment hdfsEnvironment) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.resourceFactory = Objects.requireNonNull(resourceFactory, "resourceFactory is null");
        Objects.requireNonNull(config, "config is null");
        this.catalogType = config.getCatalogType();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        Table icebergTable;
        IcebergTableLayoutHandle layoutHandle = (IcebergTableLayoutHandle)layout;
        IcebergTableHandle table = layoutHandle.getTable();
        if (!table.getSnapshotId().isPresent()) {
            return new FixedSplitSource((Iterable)ImmutableList.of());
        }
        if (this.catalogType == CatalogType.HADOOP || this.catalogType == CatalogType.NESSIE) {
            icebergTable = IcebergUtil.getNativeIcebergTable(this.resourceFactory, session, table.getSchemaTableName());
        } else {
            ExtendedHiveMetastore metastore = ((IcebergHiveMetadata)this.transactionManager.get(transaction)).getMetastore();
            icebergTable = IcebergUtil.getHiveIcebergTable(metastore, this.hdfsEnvironment, session, table.getSchemaTableName());
        }
        TableScan tableScan = ((TableScan)icebergTable.newScan().filter(ExpressionConverter.toIcebergExpression(table.getPredicate()))).useSnapshot(table.getSnapshotId().get().longValue());
        IcebergSplitSource splitSource = new IcebergSplitSource(session, tableScan, (CloseableIterable<FileScanTask>)TableScanUtil.splitFiles((CloseableIterable)tableScan.planFiles(), (long)tableScan.targetSplitSize()), IcebergSessionProperties.getMinimumAssignedSplitWeight(session));
        return splitSource;
    }
}

