/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.iceberg.IcebergConfig;
import com.facebook.presto.iceberg.nessie.NessieConfig;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;

public final class IcebergSessionProperties {
    private static final String COMPRESSION_CODEC = "compression_codec";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private static final String PARQUET_USE_COLUMN_NAMES = "parquet_use_column_names";
    private static final String PARQUET_BATCH_READ_OPTIMIZATION_ENABLED = "parquet_batch_read_optimization_enabled";
    private static final String PARQUET_BATCH_READER_VERIFICATION_ENABLED = "parquet_batch_reader_verification_enabled";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_TINY_STRIPE_THRESHOLD = "orc_tiny_stripe_threshold";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_ZSTD_JNI_DECOMPRESSION_ENABLED = "orc_zstd_jni_decompression_enabled";
    private static final String ORC_STRING_STATISTICS_LIMIT = "orc_string_statistics_limit";
    private static final String ORC_OPTIMIZED_WRITER_ENABLED = "orc_optimized_writer_enabled";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE = "orc_optimized_writer_validate";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE = "orc_optimized_writer_validate_percentage";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_MODE = "orc_optimized_writer_validate_mode";
    private static final String ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE = "orc_optimized_writer_min_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE = "orc_optimized_writer_max_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS = "orc_optimized_writer_max_stripe_rows";
    private static final String ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY = "orc_optimized_writer_max_dictionary_memory";
    private static final String ORC_COMPRESSION_CODEC = "orc_compression_codec";
    private static final String CACHE_ENABLED = "cache_enabled";
    private static final String MINIMUM_ASSIGNED_SPLIT_WEIGHT = "minimum_assigned_split_weight";
    private static final String NODE_SELECTION_STRATEGY = "node_selection_strategy";
    private static final String NESSIE_REFERENCE_NAME = "nessie_reference_name";
    private static final String NESSIE_REFERENCE_HASH = "nessie_reference_hash";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public IcebergSessionProperties(IcebergConfig icebergConfig, HiveClientConfig hiveClientConfig, ParquetFileWriterConfig parquetFileWriterConfig, OrcFileWriterConfig orcFileWriterConfig, CacheConfig cacheConfig, NessieConfig nessieConfig) {
        this.sessionProperties = ImmutableList.of((Object)new PropertyMetadata(COMPRESSION_CODEC, "The compression codec to use when writing files", (Type)VarcharType.VARCHAR, HiveCompressionCodec.class, (Object)hiveClientConfig.getCompressionCodec(), false, value -> HiveCompressionCodec.valueOf((String)((String)value).toUpperCase()), Enum::name), (Object)PropertyMetadata.booleanProperty((String)PARQUET_USE_COLUMN_NAMES, (String)"Experimental: Parquet: Access Parquet columns using names from the file", (Boolean)hiveClientConfig.isUseParquetColumnNames(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_BATCH_READ_OPTIMIZATION_ENABLED, (String)"Is Parquet batch read optimization enabled", (Boolean)hiveClientConfig.isParquetBatchReadOptimizationEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)PARQUET_BATCH_READER_VERIFICATION_ENABLED, (String)"Is Parquet batch reader verification enabled? This is for testing purposes only, not to be used in production", (Boolean)hiveClientConfig.isParquetBatchReaderVerificationEnabled(), (boolean)false), IcebergSessionProperties.dataSizeSessionProperty(PARQUET_MAX_READ_BLOCK_SIZE, "Parquet: Maximum size of a block to read", hiveClientConfig.getParquetMaxReadBlockSize(), false), IcebergSessionProperties.dataSizeSessionProperty(PARQUET_WRITER_BLOCK_SIZE, "Parquet: Writer block size", parquetFileWriterConfig.getBlockSize(), false), IcebergSessionProperties.dataSizeSessionProperty(PARQUET_WRITER_PAGE_SIZE, "Parquet: Writer page size", parquetFileWriterConfig.getPageSize(), false), (Object)PropertyMetadata.booleanProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)hiveClientConfig.isOrcBloomFiltersEnabled(), (boolean)false), IcebergSessionProperties.dataSizeSessionProperty(ORC_MAX_MERGE_DISTANCE, "ORC: Maximum size of gap between two reads to merge into a single read", hiveClientConfig.getOrcMaxMergeDistance(), false), IcebergSessionProperties.dataSizeSessionProperty(ORC_MAX_BUFFER_SIZE, "ORC: Maximum size of a single read", hiveClientConfig.getOrcMaxBufferSize(), false), IcebergSessionProperties.dataSizeSessionProperty(ORC_STREAM_BUFFER_SIZE, "ORC: Size of buffer for streaming reads", hiveClientConfig.getOrcStreamBufferSize(), false), IcebergSessionProperties.dataSizeSessionProperty(ORC_TINY_STRIPE_THRESHOLD, "ORC: Threshold below which an ORC stripe or file will read in its entirety", hiveClientConfig.getOrcTinyStripeThreshold(), false), (Object[])new PropertyMetadata[]{IcebergSessionProperties.dataSizeSessionProperty(ORC_MAX_READ_BLOCK_SIZE, "ORC: Soft max size of Presto blocks produced by ORC reader", hiveClientConfig.getOrcMaxReadBlockSize(), false), PropertyMetadata.booleanProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)hiveClientConfig.isOrcLazyReadSmallRanges(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_ZSTD_JNI_DECOMPRESSION_ENABLED, (String)"use JNI based zstd decompression for reading ORC files", (Boolean)hiveClientConfig.isZstdJniDecompressionEnabled(), (boolean)true), IcebergSessionProperties.dataSizeSessionProperty(ORC_STRING_STATISTICS_LIMIT, "ORC: Maximum size of string statistics; drop if exceeding", orcFileWriterConfig.getStringStatisticsLimit(), false), PropertyMetadata.booleanProperty((String)ORC_OPTIMIZED_WRITER_ENABLED, (String)"Experimental: ORC: Enable optimized writer", (Boolean)hiveClientConfig.isOrcOptimizedWriterEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: ORC: Force all validation for files", (Boolean)(hiveClientConfig.getOrcWriterValidationPercentage() > 0.0 ? 1 : 0), (boolean)false), new PropertyMetadata(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, "Experimental: ORC: sample percentage for validation for files", (Type)DoubleType.DOUBLE, Double.class, (Object)hiveClientConfig.getOrcWriterValidationPercentage(), false, value -> {
            double doubleValue = ((Number)value).doubleValue();
            if (doubleValue < 0.0 || doubleValue > 100.0) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 0.0 and 100.0 inclusive: %s", ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, doubleValue));
            }
            return doubleValue;
        }, value -> value), PropertyMetadata.stringProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE_MODE, (String)"Experimental: ORC: Level of detail in ORC validation", (String)hiveClientConfig.getOrcWriterValidationMode().toString(), (boolean)false), IcebergSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, "Experimental: ORC: Min stripe size", orcFileWriterConfig.getStripeMinSize(), false), IcebergSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, "Experimental: ORC: Max stripe size", orcFileWriterConfig.getStripeMaxSize(), false), PropertyMetadata.integerProperty((String)ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, (String)"Experimental: ORC: Max stripe row count", (Integer)orcFileWriterConfig.getStripeMaxRowCount(), (boolean)false), IcebergSessionProperties.dataSizeSessionProperty(ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, "Experimental: ORC: Max dictionary memory", orcFileWriterConfig.getDictionaryMaxMemory(), false), new PropertyMetadata(ORC_COMPRESSION_CODEC, "The preferred compression codec to use when writing ORC and DWRF files", (Type)VarcharType.VARCHAR, HiveCompressionCodec.class, (Object)hiveClientConfig.getOrcCompressionCodec(), false, value -> HiveCompressionCodec.valueOf((String)((String)value).toUpperCase()), Enum::name), new PropertyMetadata(NODE_SELECTION_STRATEGY, "Node affinity selection strategy", (Type)VarcharType.VARCHAR, NodeSelectionStrategy.class, (Object)hiveClientConfig.getNodeSelectionStrategy(), false, value -> NodeSelectionStrategy.valueOf((String)((String)value)), Enum::toString), PropertyMetadata.booleanProperty((String)CACHE_ENABLED, (String)"Enable cache for Iceberg", (Boolean)cacheConfig.isCachingEnabled(), (boolean)false), PropertyMetadata.doubleProperty((String)MINIMUM_ASSIGNED_SPLIT_WEIGHT, (String)"Minimum assigned split weight", (Double)icebergConfig.getMinimumAssignedSplitWeight(), (boolean)false), PropertyMetadata.stringProperty((String)NESSIE_REFERENCE_NAME, (String)"Nessie reference name to use", (String)nessieConfig.getDefaultReferenceName(), (boolean)false), PropertyMetadata.stringProperty((String)NESSIE_REFERENCE_HASH, (String)"Nessie reference hash to use", null, (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static HiveCompressionCodec getCompressionCodec(ConnectorSession session) {
        return (HiveCompressionCodec)session.getProperty(COMPRESSION_CODEC, HiveCompressionCodec.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterPageSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static PropertyMetadata<DataSize> dataSizeSessionProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.createUnboundedVarcharType(), DataSize.class, (Object)defaultValue, hidden, value -> DataSize.valueOf((String)((String)value)), DataSize::toString);
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcTinyStripeThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_TINY_STRIPE_THRESHOLD, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static boolean isOrcZstdJniDecompressionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_ZSTD_JNI_DECOMPRESSION_ENABLED, Boolean.class);
    }

    public static DataSize getOrcStringStatisticsLimit(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STRING_STATISTICS_LIMIT, DataSize.class);
    }

    public static boolean isOrcOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static boolean isOrcOptimizedWriterValidate(ConnectorSession session) {
        boolean validate = (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
        double percentage = (Double)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, Double.class);
        Preconditions.checkArgument((percentage >= 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        if (!validate) {
            return false;
        }
        return ThreadLocalRandom.current().nextDouble(100.0) < percentage;
    }

    public static OrcWriteValidation.OrcWriteValidationMode getOrcOptimizedWriterValidateMode(ConnectorSession session) {
        return OrcWriteValidation.OrcWriteValidationMode.valueOf((String)((String)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_MODE, String.class)).toUpperCase(Locale.ENGLISH));
    }

    public static DataSize getOrcOptimizedWriterMinStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, DataSize.class);
    }

    public static DataSize getOrcOptimizedWriterMaxStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static int getOrcOptimizedWriterMaxStripeRows(ConnectorSession session) {
        return (Integer)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, Integer.class);
    }

    public static DataSize getOrcOptimizedWriterMaxDictionaryMemory(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, DataSize.class);
    }

    public static HiveCompressionCodec getOrcCompressionCodec(ConnectorSession session) {
        return (HiveCompressionCodec)session.getProperty(ORC_COMPRESSION_CODEC, HiveCompressionCodec.class);
    }

    public static boolean isCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(CACHE_ENABLED, Boolean.class);
    }

    public static NodeSelectionStrategy getNodeSelectionStrategy(ConnectorSession session) {
        return (NodeSelectionStrategy)session.getProperty(NODE_SELECTION_STRATEGY, NodeSelectionStrategy.class);
    }

    public static String getNessieReferenceName(ConnectorSession session) {
        return (String)session.getProperty(NESSIE_REFERENCE_NAME, String.class);
    }

    public static String getNessieReferenceHash(ConnectorSession session) {
        return (String)session.getProperty(NESSIE_REFERENCE_HASH, String.class);
    }

    public static double getMinimumAssignedSplitWeight(ConnectorSession session) {
        return (Double)session.getProperty(MINIMUM_ASSIGNED_SPLIT_WEIGHT, Double.class);
    }
}

