/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.IcebergAbstractMetadata;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergTableProperties;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.IcebergWritableTableHandle;
import com.facebook.presto.iceberg.PartitionFields;
import com.facebook.presto.iceberg.TableStatisticsMaker;
import com.facebook.presto.iceberg.TableType;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.iceberg.util.IcebergPrestoModelConverters;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchTableException;

public class IcebergNativeMetadata
extends IcebergAbstractMetadata {
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final String TABLE_COMMENT = "comment";
    private final IcebergResourceFactory resourceFactory;
    private final CatalogType catalogType;

    public IcebergNativeMetadata(IcebergResourceFactory resourceFactory, TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec, CatalogType catalogType) {
        super(typeManager, commitTaskCodec);
        this.resourceFactory = Objects.requireNonNull(resourceFactory, "resourceFactory is null");
        this.catalogType = Objects.requireNonNull(catalogType, "catalogType is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        SupportsNamespaces supportsNamespaces = this.resourceFactory.getNamespaces(session);
        return supportsNamespaces.listNamespaces().stream().map(IcebergPrestoModelConverters::toPrestoSchemaName).collect(Collectors.toList());
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Table table;
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        Verify.verify((name.getTableType() == TableType.DATA ? 1 : 0) != 0, (String)("Wrong table type: " + (Object)((Object)name.getTableType())), (Object[])new Object[0]);
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(tableName.getSchemaName(), name.getTableName());
        try {
            table = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        }
        catch (NoSuchTableException e) {
            return null;
        }
        return new IcebergTableHandle(tableName.getSchemaName(), name.getTableName(), name.getTableType(), IcebergUtil.resolveSnapshotIdByName(table, name), (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        Table table;
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        if (name.getTableType() == TableType.DATA) {
            return Optional.empty();
        }
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(tableName.getSchemaName(), name.getTableName());
        try {
            table = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        }
        catch (NoSuchTableException e) {
            return Optional.empty();
        }
        if (name.getSnapshotId().isPresent() && table.snapshot(name.getSnapshotId().get().longValue()) == null) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, String.format("Invalid snapshot [%s] for table: %s", name.getSnapshotId().get(), table));
        }
        return this.getIcebergSystemTable(tableName, table);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && INFORMATION_SCHEMA.equals(schemaName.get())) {
            return this.listSchemaNames(session).stream().map(schema -> new SchemaTableName(INFORMATION_SCHEMA, schema)).collect(Collectors.toList());
        }
        return this.resourceFactory.getCatalog(session).listTables(IcebergPrestoModelConverters.toIcebergNamespace(schemaName)).stream().map(IcebergPrestoModelConverters::toPrestoSchemaTableName).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = IcebergUtil.getNativeIcebergTable(this.resourceFactory, session, table.getSchemaTableName());
        return (Map)IcebergUtil.getColumns(icebergTable.schema(), this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getName, Function.identity()));
    }

    @Override
    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(column.getComment()).setHidden(false).build();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        this.resourceFactory.getNamespaces(session).createNamespace(IcebergPrestoModelConverters.toIcebergNamespace(Optional.of(schemaName)), properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString())));
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        try {
            this.resourceFactory.getNamespaces(session).dropNamespace(IcebergPrestoModelConverters.toIcebergNamespace(Optional.of(schemaName)));
        }
        catch (NamespaceNotEmptyException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Iceberg %s catalog does not support rename namespace", this.catalogType.name()));
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        String formatVersion;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Schema schema = IcebergNativeMetadata.toIcebergSchema(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        FileFormat fileFormat = IcebergTableProperties.getFileFormat(tableMetadata.getProperties());
        propertiesBuilder.put((Object)"write.format.default", (Object)fileFormat.toString());
        if (tableMetadata.getComment().isPresent()) {
            propertiesBuilder.put((Object)TABLE_COMMENT, tableMetadata.getComment().get());
        }
        if ((formatVersion = IcebergTableProperties.getFormatVersion(tableMetadata.getProperties())) != null) {
            propertiesBuilder.put((Object)"format-version", (Object)formatVersion);
        }
        try {
            this.transaction = this.resourceFactory.getCatalog(session).newCreateTableTransaction(IcebergPrestoModelConverters.toIcebergTableIdentifier(schemaTableName), schema, partitionSpec, (Map)propertiesBuilder.build());
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        Table icebergTable = this.transaction.table();
        return new IcebergWritableTableHandle(schemaName, tableName, SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), icebergTable.location(), fileFormat, icebergTable.properties());
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = IcebergUtil.getNativeIcebergTable(this.resourceFactory, session, table.getSchemaTableName());
        return this.beginIcebergTableInsert(table, icebergTable);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        this.resourceFactory.getCatalog(session).dropTable(tableIdentifier);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        TableIdentifier from = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        TableIdentifier to = IcebergPrestoModelConverters.toIcebergTableIdentifier(newTable);
        this.resourceFactory.getCatalog(session).renameTable(from, to);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        icebergTable.updateSchema().addColumn(column.getName(), TypeConverter.toIcebergType(column.getType()), column.getComment()).commit();
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        icebergTable.updateSchema().deleteColumn(handle.getName()).commit();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
    }

    @Override
    protected ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName table) {
        Table icebergTable;
        try {
            icebergTable = IcebergUtil.getNativeIcebergTable(this.resourceFactory, session, table);
        }
        catch (NoSuchTableException e) {
            throw new TableNotFoundException(table);
        }
        List<ColumnMetadata> columns = this.getColumnMetadatas(icebergTable);
        return new ConnectorTableMetadata(table, columns, this.createMetadataProperties(icebergTable), IcebergUtil.getTableComment(icebergTable));
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = IcebergUtil.getNativeIcebergTable(this.resourceFactory, session, handle.getSchemaTableName());
        return TableStatisticsMaker.getTableStatistics(this.typeManager, constraint, handle, icebergTable);
    }
}

