/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.iceberg.IcebergHandleResolver;
import com.facebook.presto.iceberg.InternalIcebergConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;

public class IcebergConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "iceberg";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new IcebergHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        ClassLoader classLoader = IcebergConnectorFactory.class.getClassLoader();
        try {
            return (Connector)classLoader.loadClass(InternalIcebergConnectorFactory.class.getName()).getMethod("createConnector", String.class, Map.class, ConnectorContext.class, Optional.class).invoke(null, catalogName, config, context, Optional.empty());
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            Throwables.throwIfUnchecked((Throwable)targetException);
            throw new RuntimeException(targetException);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

