/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.IcebergFileFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.iceberg.FileFormat;

public class IcebergConfig {
    private IcebergFileFormat fileFormat = IcebergFileFormat.PARQUET;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.GZIP;
    private CatalogType catalogType = CatalogType.HIVE;
    private String catalogWarehouse;
    private int catalogCacheSize = 10;
    private int maxPartitionsPerWriter = 100;
    private List<String> hadoopConfigResources = ImmutableList.of();
    private double minimumAssignedSplitWeight = 0.05;

    @NotNull
    public FileFormat getFileFormat() {
        return FileFormat.valueOf((String)this.fileFormat.name());
    }

    @Config(value="iceberg.file-format")
    public IcebergConfig setFileFormat(IcebergFileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @NotNull
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="iceberg.compression-codec")
    public IcebergConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    @NotNull
    public CatalogType getCatalogType() {
        return this.catalogType;
    }

    @Config(value="iceberg.catalog.type")
    @ConfigDescription(value="Iceberg catalog type")
    public IcebergConfig setCatalogType(CatalogType catalogType) {
        this.catalogType = catalogType;
        return this;
    }

    public String getCatalogWarehouse() {
        return this.catalogWarehouse;
    }

    @Config(value="iceberg.catalog.warehouse")
    @ConfigDescription(value="Iceberg catalog warehouse root path")
    public IcebergConfig setCatalogWarehouse(String catalogWarehouse) {
        this.catalogWarehouse = catalogWarehouse;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getCatalogCacheSize() {
        return this.catalogCacheSize;
    }

    @Config(value="iceberg.catalog.cached-catalog-num")
    @ConfigDescription(value="number of Iceberg catalog to cache across all sessions")
    public IcebergConfig setCatalogCacheSize(int catalogCacheSize) {
        this.catalogCacheSize = catalogCacheSize;
        return this;
    }

    public List<String> getHadoopConfigResources() {
        return this.hadoopConfigResources;
    }

    @Config(value="iceberg.hadoop.config.resources")
    @ConfigDescription(value="Comma separated paths to Hadoop configuration resource files")
    public IcebergConfig setHadoopConfigResources(String files) {
        if (files != null) {
            this.hadoopConfigResources = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        }
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="iceberg.max-partitions-per-writer")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public IcebergConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    @Config(value="iceberg.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned")
    public IcebergConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }
}

