/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;

public class HdfsInputFile
implements InputFile {
    private final InputFile delegate;
    private final HdfsEnvironment environment;
    private final String user;

    public HdfsInputFile(Path path, HdfsEnvironment environment, HdfsContext context) {
        Objects.requireNonNull(path, "path is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        Objects.requireNonNull(context, "context is null");
        try {
            this.delegate = HadoopInputFile.fromPath((Path)path, (FileSystem)environment.getFileSystem(context, path), (Configuration)environment.getConfiguration(context, path));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_FILESYSTEM_ERROR, "Failed to create input file: " + path, (Throwable)e);
        }
        this.user = context.getIdentity().getUser();
    }

    public long getLength() {
        return (Long)this.environment.doAs(this.user, () -> ((InputFile)this.delegate).getLength());
    }

    public SeekableInputStream newStream() {
        return new HdfsInputStream((SeekableInputStream)this.environment.doAs(this.user, () -> ((InputFile)this.delegate).newStream()));
    }

    public String location() {
        return this.delegate.location();
    }

    public boolean exists() {
        return (Boolean)this.environment.doAs(this.user, () -> ((InputFile)this.delegate).exists());
    }

    private static class HdfsInputStream
    extends SeekableInputStream {
        private final SeekableInputStream delegate;

        public HdfsInputStream(SeekableInputStream delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long getPos() throws IOException {
            return this.delegate.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.delegate.seek(newPos);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

