/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.Partition;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;

public class PartitionTable
implements SystemTable {
    private final TypeManager typeManager;
    private final Table icebergTable;
    private final Optional<Long> snapshotId;
    private final Map<Integer, Type.PrimitiveType> idToTypeMapping;
    private final List<Types.NestedField> nonPartitionPrimitiveColumns;
    private final List<com.facebook.presto.common.type.Type> partitionColumnTypes;
    private final List<com.facebook.presto.common.type.Type> resultTypes;
    private final List<RowType> columnMetricTypes;
    private final ConnectorTableMetadata connectorTableMetadata;

    public PartitionTable(SchemaTableName tableName, TypeManager typeManager, Table icebergTable, Optional<Long> snapshotId) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.icebergTable = Objects.requireNonNull(icebergTable, "icebergTable is null");
        this.snapshotId = Objects.requireNonNull(snapshotId, "snapshotId is null");
        this.idToTypeMapping = icebergTable.schema().columns().stream().filter(column -> column.type().isPrimitiveType()).collect(Collectors.toMap(Types.NestedField::fieldId, column -> column.type().asPrimitiveType()));
        List columns = icebergTable.schema().columns();
        List partitionFields = icebergTable.spec().fields();
        ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
        List<ColumnMetadata> partitionColumnsMetadata = this.getPartitionColumnsMetadata(partitionFields, icebergTable.schema());
        this.partitionColumnTypes = (List)partitionColumnsMetadata.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        columnMetadataBuilder.addAll(partitionColumnsMetadata);
        Set identityPartitionIds = IcebergUtil.getIdentityPartitions(icebergTable.spec()).keySet().stream().map(PartitionField::sourceId).collect(Collectors.toSet());
        this.nonPartitionPrimitiveColumns = (List)columns.stream().filter(column -> !identityPartitionIds.contains(column.fieldId()) && column.type().isPrimitiveType()).collect(ImmutableList.toImmutableList());
        ImmutableList.of((Object)"row_count", (Object)"file_count", (Object)"total_size").forEach(metric -> columnMetadataBuilder.add((Object)new ColumnMetadata(metric, (com.facebook.presto.common.type.Type)BigintType.BIGINT)));
        List<ColumnMetadata> columnMetricsMetadata = this.getColumnMetadata(this.nonPartitionPrimitiveColumns);
        columnMetadataBuilder.addAll(columnMetricsMetadata);
        this.columnMetricTypes = (List)columnMetricsMetadata.stream().map(m -> (RowType)m.getType()).collect(ImmutableList.toImmutableList());
        ImmutableList columnMetadata = columnMetadataBuilder.build();
        this.resultTypes = (List)columnMetadata.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        this.connectorTableMetadata = new ConnectorTableMetadata(tableName, (List)columnMetadata);
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.connectorTableMetadata;
    }

    private List<ColumnMetadata> getPartitionColumnsMetadata(List<PartitionField> fields, Schema schema) {
        return (List)fields.stream().map(field -> new ColumnMetadata(field.name(), TypeConverter.toPrestoType(field.transform().getResultType(schema.findType(field.sourceId())), this.typeManager))).collect(ImmutableList.toImmutableList());
    }

    private List<ColumnMetadata> getColumnMetadata(List<Types.NestedField> columns) {
        return (List)columns.stream().map(column -> new ColumnMetadata(column.name(), (com.facebook.presto.common.type.Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("min"), TypeConverter.toPrestoType(column.type(), this.typeManager)), (Object)new RowType.Field(Optional.of("max"), TypeConverter.toPrestoType(column.type(), this.typeManager)), (Object)new RowType.Field(Optional.of("null_count"), (com.facebook.presto.common.type.Type)BigintType.BIGINT))))).collect(ImmutableList.toImmutableList());
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        if (!this.snapshotId.isPresent()) {
            return new InMemoryRecordSet(this.resultTypes, (Iterable)ImmutableList.of()).cursor();
        }
        TableScan tableScan = this.icebergTable.newScan().useSnapshot(this.snapshotId.get().longValue()).includeColumnStats();
        return this.buildRecordCursor(this.getPartitions(tableScan), this.icebergTable.spec().fields());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<StructLikeWrapper, Partition> getPartitions(TableScan tableScan) {
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            HashMap<StructLikeWrapper, Partition> partitions = new HashMap<StructLikeWrapper, Partition>();
            for (FileScanTask fileScanTask : fileScanTasks) {
                Partition partition;
                DataFile dataFile = fileScanTask.file();
                Types.StructType structType = fileScanTask.spec().partitionType();
                StructLike partitionStruct = dataFile.partition();
                StructLikeWrapper partitionWrapper = StructLikeWrapper.forType((Types.StructType)structType).set(partitionStruct);
                if (!partitions.containsKey(partitionWrapper)) {
                    partition = new Partition(this.idToTypeMapping, this.nonPartitionPrimitiveColumns, partitionStruct, dataFile.recordCount(), dataFile.fileSizeInBytes(), this.toMap(dataFile.lowerBounds()), this.toMap(dataFile.upperBounds()), dataFile.nullValueCounts(), dataFile.columnSizes());
                    partitions.put(partitionWrapper, partition);
                    continue;
                }
                partition = (Partition)partitions.get(partitionWrapper);
                partition.incrementFileCount();
                partition.incrementRecordCount(dataFile.recordCount());
                partition.incrementSize(dataFile.fileSizeInBytes());
                partition.updateMin(this.toMap(dataFile.lowerBounds()), dataFile.nullValueCounts(), dataFile.recordCount());
                partition.updateMax(this.toMap(dataFile.upperBounds()), dataFile.nullValueCounts(), dataFile.recordCount());
                partition.updateNullCount(dataFile.nullValueCounts());
            }
            Object object = partitions;
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private RecordCursor buildRecordCursor(Map<StructLikeWrapper, Partition> partitions, List<PartitionField> partitionFields) {
        List<Type> partitionTypes = this.partitionTypes(partitionFields);
        List partitionColumnClass = (List)partitionTypes.stream().map(type -> type.typeId().javaClass()).collect(ImmutableList.toImmutableList());
        int columnCounts = this.partitionColumnTypes.size() + 3 + this.columnMetricTypes.size();
        ImmutableList.Builder records = ImmutableList.builder();
        for (Partition partition : partitions.values()) {
            int i;
            ArrayList<Object> row = new ArrayList<Object>(columnCounts);
            for (i = 0; i < this.partitionColumnTypes.size(); ++i) {
                row.add(PartitionTable.convert(partition.getValues().get(i, (Class)partitionColumnClass.get(i)), partitionTypes.get(i)));
            }
            row.add(partition.getRecordCount());
            row.add(partition.getFileCount());
            row.add(partition.getSize());
            for (i = 0; i < this.columnMetricTypes.size(); ++i) {
                if (!partition.hasValidColumnMetrics()) {
                    row.add(null);
                    continue;
                }
                Integer fieldId = this.nonPartitionPrimitiveColumns.get(i).fieldId();
                Type.PrimitiveType type2 = this.idToTypeMapping.get(fieldId);
                Object min = PartitionTable.convert(partition.getMinValues().get(fieldId), (Type)type2);
                Object max = PartitionTable.convert(partition.getMaxValues().get(fieldId), (Type)type2);
                Long nullCount = partition.getNullCounts().get(fieldId);
                row.add(PartitionTable.getColumnMetricBlock(this.columnMetricTypes.get(i), min, max, nullCount));
            }
            records.add(row);
        }
        return new InMemoryRecordSet(this.resultTypes, (Iterable)records.build()).cursor();
    }

    private List<Type> partitionTypes(List<PartitionField> partitionFields) {
        ImmutableList.Builder partitionTypeBuilder = ImmutableList.builder();
        for (PartitionField partitionField : partitionFields) {
            Type.PrimitiveType sourceType = this.idToTypeMapping.get(partitionField.sourceId());
            Type type = partitionField.transform().getResultType((Type)sourceType);
            partitionTypeBuilder.add((Object)type);
        }
        return partitionTypeBuilder.build();
    }

    private static Block getColumnMetricBlock(RowType columnMetricType, Object min, Object max, Long nullCount) {
        BlockBuilder rowBlockBuilder = columnMetricType.createBlockBuilder(null, 1);
        BlockBuilder builder = rowBlockBuilder.beginBlockEntry();
        List fields = columnMetricType.getFields();
        TypeUtils.writeNativeValue((com.facebook.presto.common.type.Type)((RowType.Field)fields.get(0)).getType(), (BlockBuilder)builder, (Object)min);
        TypeUtils.writeNativeValue((com.facebook.presto.common.type.Type)((RowType.Field)fields.get(1)).getType(), (BlockBuilder)builder, (Object)max);
        TypeUtils.writeNativeValue((com.facebook.presto.common.type.Type)((RowType.Field)fields.get(2)).getType(), (BlockBuilder)builder, (Object)nullCount);
        rowBlockBuilder.closeEntry();
        return columnMetricType.getObject((Block)rowBlockBuilder, 0);
    }

    private Map<Integer, Object> toMap(Map<Integer, ByteBuffer> idToMetricMap) {
        return Partition.toMap(this.idToTypeMapping, idToMetricMap);
    }

    public static Object convert(Object value, Type type) {
        if (value == null) {
            return null;
        }
        if (type instanceof Types.StringType) {
            return value.toString();
        }
        if (type instanceof Types.BinaryType) {
            return ((ByteBuffer)value).array();
        }
        if (type instanceof Types.FloatType) {
            return Float.floatToIntBits(((Float)value).floatValue());
        }
        return value;
    }
}

