/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.iceberg.ExpressionConverter;
import com.facebook.presto.iceberg.HiveTableOperations;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.iceberg.util.IcebergPrestoModelConverters;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.LocationProvider;

public final class IcebergUtil {
    private static final Pattern SIMPLE_NAME = Pattern.compile("[a-z][a-z0-9]*");

    private IcebergUtil() {
    }

    public static boolean isIcebergTable(com.facebook.presto.hive.metastore.Table table) {
        return "iceberg".equalsIgnoreCase((String)table.getParameters().get("table_type"));
    }

    public static Table getHiveIcebergTable(ExtendedHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, ConnectorSession session, SchemaTableName table) {
        HdfsContext hdfsContext = new HdfsContext(session, table.getSchemaName(), table.getTableName());
        HiveTableOperations operations = new HiveTableOperations(metastore, new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER), hdfsEnvironment, hdfsContext, table.getSchemaName(), table.getTableName());
        return new BaseTable((TableOperations)operations, IcebergUtil.quotedTableName(table));
    }

    public static Table getHadoopIcebergTable(IcebergResourceFactory resourceFactory, ConnectorSession session, SchemaTableName table) {
        return resourceFactory.getCatalog(session).loadTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(table));
    }

    public static long resolveSnapshotId(Table table, long snapshotId) {
        if (table.snapshot(snapshotId) != null) {
            return snapshotId;
        }
        return Lists.reverse((List)table.history()).stream().filter(entry -> entry.timestampMillis() <= snapshotId).map(HistoryEntry::snapshotId).findFirst().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, String.format("Invalid snapshot [%s] for table: %s", snapshotId, table)));
    }

    public static Optional<Long> resolveSnapshotIdByName(Table table, IcebergTableName name) {
        if (name.getSnapshotId().isPresent()) {
            if (table.snapshot(name.getSnapshotId().get().longValue()) == null) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, String.format("Invalid snapshot [%s] for table: %s", name.getSnapshotId().get(), table));
            }
            return name.getSnapshotId();
        }
        return Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId);
    }

    public static List<IcebergColumnHandle> getColumns(Schema schema, TypeManager typeManager) {
        return (List)schema.columns().stream().map(column -> new IcebergColumnHandle(column.fieldId(), column.name(), TypeConverter.toPrestoType(column.type(), typeManager), Optional.ofNullable(column.doc()))).collect(ImmutableList.toImmutableList());
    }

    public static Map<PartitionField, Integer> getIdentityPartitions(PartitionSpec partitionSpec) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (int i = 0; i < partitionSpec.fields().size(); ++i) {
            PartitionField field = (PartitionField)partitionSpec.fields().get(i);
            if (!field.transform().toString().equals("identity")) continue;
            columns.put((Object)field, (Object)i);
        }
        return columns.build();
    }

    public static FileFormat getFileFormat(Table table) {
        return FileFormat.valueOf((String)table.properties().getOrDefault("write.format.default", "parquet").toUpperCase(Locale.ENGLISH));
    }

    public static Optional<String> getTableComment(Table table) {
        return Optional.ofNullable(table.properties().get("comment"));
    }

    private static String quotedTableName(SchemaTableName name) {
        return IcebergUtil.quotedName(name.getSchemaName()) + "." + IcebergUtil.quotedName(name.getTableName());
    }

    private static String quotedName(String name) {
        if (SIMPLE_NAME.matcher(name).matches()) {
            return name;
        }
        return '\"' + name.replace("\"", "\"\"") + '\"';
    }

    public static TableScan getTableScan(TupleDomain<IcebergColumnHandle> predicates, Optional<Long> snapshotId, Table icebergTable) {
        Expression expression = ExpressionConverter.toIcebergExpression(predicates);
        TableScan tableScan = icebergTable.newScan().filter(expression);
        return snapshotId.map(id -> IcebergUtil.isSnapshot(icebergTable, id) ? tableScan.useSnapshot(id.longValue()) : tableScan.asOfTime(id.longValue())).orElse(tableScan);
    }

    private static boolean isSnapshot(Table icebergTable, Long id) {
        return Streams.stream((Iterable)icebergTable.snapshots()).anyMatch(snapshot -> snapshot.snapshotId() == id.longValue());
    }

    public static LocationProvider getLocationProvider(SchemaTableName schemaTableName, String tableLocation, Map<String, String> storageProperties) {
        if (storageProperties.containsKey("write.location-provider.impl")) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table " + schemaTableName + " specifies " + storageProperties.get("write.location-provider.impl") + " as a location provider. Writing to Iceberg tables with custom location provider is not supported.");
        }
        return LocationProviders.locationsFor((String)tableLocation, storageProperties);
    }
}

