/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveOrcAggregatedMemoryContext;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.hive.orc.OrcBatchPageSource;
import com.facebook.presto.hive.orc.ProjectionBasedDwrfKeyProvider;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergOrcColumn;
import com.facebook.presto.iceberg.IcebergPageSource;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.IcebergSplit;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableLayoutHandle;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.TupleDomainOrcPredicate;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.PredicateUtils;
import com.facebook.presto.parquet.reader.ColumnIndexFilterUtils;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.iceberg.FileFormat;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOConverter;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class IcebergPageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final TypeManager typeManager;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSourceFactory stripeMetadataSourceFactory;
    private final DwrfEncryptionProvider dwrfEncryptionProvider;
    private final HiveClientConfig hiveClientConfig;

    @Inject
    public IcebergPageSourceProvider(HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats fileFormatDataSourceStats, TypeManager typeManager, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, HiveDwrfEncryptionProvider dwrfEncryptionProvider, HiveClientConfig hiveClientConfig) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
        this.stripeMetadataSourceFactory = Objects.requireNonNull(stripeMetadataSourceFactory, "stripeMetadataSourceFactory is null");
        this.dwrfEncryptionProvider = Objects.requireNonNull(dwrfEncryptionProvider, "DwrfEncryptionProvider is null").toDwrfEncryptionProvider();
        this.hiveClientConfig = Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableLayoutHandle layout, List<ColumnHandle> columns, SplitContext splitContext) {
        IcebergSplit split = (IcebergSplit)connectorSplit;
        IcebergTableLayoutHandle icebergLayout = (IcebergTableLayoutHandle)layout;
        IcebergTableHandle table = icebergLayout.getTable();
        List icebergColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        Map<Integer, String> partitionKeys = split.getPartitionKeys();
        List regularColumns = (List)columns.stream().map(IcebergColumnHandle.class::cast).filter(column -> !partitionKeys.containsKey(column.getId())).collect(ImmutableList.toImmutableList());
        HdfsContext hdfsContext = new HdfsContext(session, table.getSchemaName(), table.getTableName());
        ConnectorPageSource dataPageSource = this.createDataPageSource(session, hdfsContext, new Path(split.getPath()), split.getStart(), split.getLength(), split.getFileFormat(), table.getSchemaTableName(), regularColumns, table.getPredicate(), splitContext.isCacheable());
        return new IcebergPageSource(icebergColumns, partitionKeys, dataPageSource, session.getSqlFunctionProperties().getTimeZoneKey());
    }

    private ConnectorPageSource createDataPageSource(ConnectorSession session, HdfsContext hdfsContext, Path path, long start, long length, FileFormat fileFormat, SchemaTableName tableName, List<IcebergColumnHandle> dataColumns, TupleDomain<IcebergColumnHandle> predicate, boolean isCacheable) {
        switch (fileFormat) {
            case PARQUET: {
                return IcebergPageSourceProvider.createParquetPageSource(this.hdfsEnvironment, session.getUser(), this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, tableName, dataColumns, HiveSessionProperties.isUseParquetColumnNames((ConnectorSession)session), HiveSessionProperties.getParquetMaxReadBlockSize((ConnectorSession)session), HiveSessionProperties.isParquetBatchReadsEnabled((ConnectorSession)session), HiveSessionProperties.isParquetBatchReaderVerificationEnabled((ConnectorSession)session), predicate, this.fileFormatDataSourceStats, false);
            }
            case ORC: {
                OrcReaderOptions readerOptions = new OrcReaderOptions(IcebergSessionProperties.getOrcMaxMergeDistance(session), IcebergSessionProperties.getOrcTinyStripeThreshold(session), IcebergSessionProperties.getOrcMaxReadBlockSize(session), IcebergSessionProperties.isOrcZstdJniDecompressionEnabled(session));
                return IcebergPageSourceProvider.createBatchOrcPageSource(this.hdfsEnvironment, session.getUser(), this.hdfsEnvironment.getConfiguration(hdfsContext, path), path, start, length, isCacheable, dataColumns, this.typeManager, predicate, readerOptions, OrcEncoding.ORC, IcebergSessionProperties.getOrcMaxBufferSize(session), IcebergSessionProperties.getOrcStreamBufferSize(session), IcebergSessionProperties.getOrcLazyReadSmallRanges(session), IcebergSessionProperties.isOrcBloomFiltersEnabled(session), this.hiveClientConfig.getDomainCompactionThreshold(), this.orcFileTailSource, this.stripeMetadataSourceFactory, this.fileFormatDataSourceStats, Optional.empty(), this.dwrfEncryptionProvider);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + fileFormat);
    }

    private static ConnectorPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, String user, Configuration configuration, Path path, long start, long length, SchemaTableName tableName, List<IcebergColumnHandle> regularColumns, boolean useParquetColumnNames, DataSize maxReadBlockSize, boolean batchReaderEnabled, boolean verificationEnabled, TupleDomain<IcebergColumnHandle> effectivePredicate, FileFormatDataSourceStats fileFormatDataSourceStats, boolean columnIndexFilterEnabled) {
        AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        HdfsParquetDataSource dataSource = null;
        try {
            ExtendedFileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            long fileSize = fileStatus.getLen();
            long modificationTime = fileStatus.getModificationTime();
            HiveFileContext hiveFileContext = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), Optional.of(fileSize), modificationTime, false);
            FSDataInputStream inputStream = fileSystem.openFile(path, hiveFileContext);
            dataSource = HdfsParquetDataSource.buildHdfsParquetDataSource((FSDataInputStream)inputStream, (Path)path, (FileFormatDataSourceStats)fileFormatDataSourceStats);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, (long)fileSize).getParquetMetadata();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            Map parquetIdToField = (Map)fileSchema.getFields().stream().filter(field -> field.getId() != null).collect(ImmutableMap.toImmutableMap(field -> field.getId().intValue(), Function.identity()));
            List parquetFields = regularColumns.stream().map(column -> {
                if (parquetIdToField.isEmpty()) {
                    return ParquetTypeUtils.getParquetTypeByName((String)column.getName(), (GroupType)fileSchema);
                }
                return (Type)parquetIdToField.get(column.getId());
            }).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), (List)parquetFields.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = IcebergPageSourceProvider.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath);
            HdfsParquetDataSource finalDataSource = dataSource;
            ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
            ArrayList<Object> blockIndexStores = new ArrayList<Object>();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                Optional columnIndexStore = ColumnIndexFilterUtils.getColumnIndexStore((Predicate)parquetPredicate, (ParquetDataSource)finalDataSource, (BlockMetaData)block, (Map)descriptorsByPath, (boolean)columnIndexFilterEnabled);
                if (firstDataPage < start || firstDataPage >= start + length || !PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)dataSource, (Map)descriptorsByPath, parquetTupleDomain, (Optional)columnIndexStore, (boolean)columnIndexFilterEnabled)) continue;
                blocks.add(block);
                blockIndexStores.add(columnIndexStore.orElse(null));
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(messageColumnIO, blocks, (ParquetDataSource)dataSource, systemMemoryContext, maxReadBlockSize, batchReaderEnabled, verificationEnabled, parquetPredicate, blockIndexStores, columnIndexFilterEnabled);
            ImmutableList.Builder namesBuilder = ImmutableList.builder();
            ImmutableList.Builder prestoTypes = ImmutableList.builder();
            ImmutableList.Builder internalFields = ImmutableList.builder();
            for (int columnIndex = 0; columnIndex < regularColumns.size(); ++columnIndex) {
                IcebergColumnHandle column2 = regularColumns.get(columnIndex);
                namesBuilder.add((Object)column2.getName());
                Type parquetField = (Type)parquetFields.get(columnIndex);
                com.facebook.presto.common.type.Type prestoType = column2.getType();
                prestoTypes.add((Object)prestoType);
                if (parquetField == null) {
                    internalFields.add(Optional.empty());
                    continue;
                }
                internalFields.add((Object)ColumnIOConverter.constructField((com.facebook.presto.common.type.Type)column2.getType(), (ColumnIO)messageColumnIO.getChild(parquetField.getName())));
            }
            return new ParquetPageSource(parquetReader, (List)prestoTypes.build(), (List)internalFields.build(), (List)namesBuilder.build(), new RuntimeStats());
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException fileStatus) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof ParquetCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_BAD_DATA, message, (Throwable)e);
            }
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<IcebergColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().get()).forEach((columnHandle, domain) -> {
            RichColumnDescriptor descriptor;
            String baseType = columnHandle.getType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row") || (descriptor = (RichColumnDescriptor)descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()))) == null)) {
                predicate.put((Object)descriptor, domain);
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.build());
    }

    private static ConnectorPageSource createBatchOrcPageSource(HdfsEnvironment hdfsEnvironment, String user, Configuration configuration, Path path, long start, long length, boolean isCacheable, List<IcebergColumnHandle> regularColumns, TypeManager typeManager, TupleDomain<IcebergColumnHandle> effectivePredicate, OrcReaderOptions options, OrcEncoding orcEncoding, DataSize maxBufferSize, DataSize streamBufferSize, boolean lazyReadSmallRanges, boolean orcBloomFiltersEnabled, int domainCompactionThreshold, OrcFileTailSource orcFileTailSource, StripeMetadataSourceFactory stripeMetadataSourceFactory, FileFormatDataSourceStats stats, Optional<EncryptionInformation> encryptionInformation, DwrfEncryptionProvider dwrfEncryptionProvider) {
        HdfsOrcDataSource orcDataSource = null;
        try {
            ExtendedFileSystem fileSystem = hdfsEnvironment.getFileSystem(user, path, configuration);
            FileStatus fileStatus = fileSystem.getFileStatus(path);
            long fileSize = fileStatus.getLen();
            long modificationTime = fileStatus.getModificationTime();
            HiveFileContext hiveFileContext = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), Optional.of(fileSize), modificationTime, false);
            FSDataInputStream inputStream = (FSDataInputStream)hdfsEnvironment.doAs(user, () -> fileSystem.openFile(path, hiveFileContext));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), fileSize, options.getMaxMergeDistance(), maxBufferSize, streamBufferSize, lazyReadSmallRanges, inputStream, stats);
            ProjectionBasedDwrfKeyProvider dwrfKeyProvider = new ProjectionBasedDwrfKeyProvider(encryptionInformation, (List)ImmutableList.of(), true, path);
            RuntimeStats runtimeStats = new RuntimeStats();
            OrcReader reader = new OrcReader((OrcDataSource)orcDataSource, orcEncoding, orcFileTailSource, stripeMetadataSourceFactory, (OrcAggregatedMemoryContext)new HiveOrcAggregatedMemoryContext(), options, isCacheable, dwrfEncryptionProvider, (DwrfKeyProvider)dwrfKeyProvider, runtimeStats);
            ArrayList<HiveColumnHandle> physicalColumnHandles = new ArrayList<HiveColumnHandle>(regularColumns.size());
            ImmutableMap.Builder includedColumns = ImmutableMap.builder();
            ImmutableList.Builder columnReferences = ImmutableList.builder();
            List<IcebergOrcColumn> fileOrcColumns = IcebergPageSourceProvider.getFileOrcColumns(reader);
            Map fileOrcColumnByIcebergId = (Map)fileOrcColumns.stream().filter(orcColumn -> orcColumn.getAttributes().containsKey("iceberg.id")).collect(ImmutableMap.toImmutableMap(orcColumn -> Integer.parseInt(orcColumn.getAttributes().get("iceberg.id")), orcColumn -> IcebergOrcColumn.copy(orcColumn).setIcebergColumnId(Optional.of(Integer.parseInt(orcColumn.getAttributes().get("iceberg.id"))))));
            ImmutableMap fileOrcColumnsByName = Maps.uniqueIndex(fileOrcColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
            int nextMissingColumnIndex = fileOrcColumnsByName.size();
            for (IcebergColumnHandle column : regularColumns) {
                IcebergOrcColumn icebergOrcColumn;
                boolean isExcludeColumn = false;
                if (fileOrcColumnByIcebergId.isEmpty()) {
                    icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnsByName.get(column.getName());
                } else {
                    icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnByIcebergId.get(column.getId());
                    if (icebergOrcColumn == null && (icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnsByName.get(column.getName())) != null) {
                        isExcludeColumn = true;
                    }
                }
                if (icebergOrcColumn != null) {
                    HiveColumnHandle columnHandle = new HiveColumnHandle(column.getName(), TypeConverter.toHiveType(column.getType()), column.getType().getTypeSignature(), icebergOrcColumn.getOrcColumnId(), icebergOrcColumn.getColumnType(), Optional.empty(), Optional.empty());
                    physicalColumnHandles.add(columnHandle);
                    if (isExcludeColumn) continue;
                    includedColumns.put((Object)columnHandle.getHiveColumnIndex(), (Object)typeManager.getType(columnHandle.getTypeSignature()));
                    columnReferences.add((Object)new TupleDomainOrcPredicate.ColumnReference((Object)columnHandle, columnHandle.getHiveColumnIndex(), typeManager.getType(columnHandle.getTypeSignature())));
                    continue;
                }
                physicalColumnHandles.add(new HiveColumnHandle(column.getName(), TypeConverter.toHiveType(column.getType()), column.getType().getTypeSignature(), nextMissingColumnIndex++, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
            }
            TupleDomain hiveColumnHandleTupleDomain = effectivePredicate.transform(arg_0 -> IcebergPageSourceProvider.lambda$createBatchOrcPageSource$10(fileOrcColumnByIcebergId, (Map)fileOrcColumnsByName, arg_0));
            TupleDomainOrcPredicate predicate = new TupleDomainOrcPredicate(hiveColumnHandleTupleDomain, (List)columnReferences.build(), orcBloomFiltersEnabled, Optional.of(domainCompactionThreshold));
            HiveOrcAggregatedMemoryContext systemMemoryUsage = new HiveOrcAggregatedMemoryContext();
            OrcBatchRecordReader recordReader = reader.createBatchRecordReader((Map)includedColumns.build(), (OrcPredicate)predicate, start, length, DateTimeZone.UTC, (OrcAggregatedMemoryContext)systemMemoryUsage, 1);
            return new OrcBatchPageSource(recordReader, (OrcDataSource)orcDataSource, physicalColumnHandles, typeManager, (OrcAggregatedMemoryContext)systemMemoryUsage, stats, runtimeStats);
        }
        catch (Exception e) {
            if (orcDataSource != null) {
                try {
                    orcDataSource.close();
                }
                catch (IOException fileStatus) {
                    // empty catch block
                }
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = String.format("Error opening Iceberg split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e instanceof BlockMissingException) {
                throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    private static List<IcebergOrcColumn> getFileOrcColumns(OrcReader reader) {
        List orcTypes = reader.getFooter().getTypes();
        OrcType rootOrcType = (OrcType)orcTypes.get(0);
        Object columnAttributes = ImmutableList.of();
        if (rootOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT) {
            columnAttributes = (List)IntStream.range(0, rootOrcType.getFieldCount()).mapToObj(fieldId -> new IcebergOrcColumn(fieldId, rootOrcType.getFieldTypeIndex(fieldId), Optional.empty(), rootOrcType.getFieldName(fieldId), HiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(fieldId))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(fieldId))).getAttributes())).collect(ImmutableList.toImmutableList());
        } else if (rootOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.LIST) {
            columnAttributes = ImmutableList.of((Object)new IcebergOrcColumn(0, rootOrcType.getFieldTypeIndex(0), Optional.empty(), "item", HiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(0))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(0))).getAttributes()));
        } else if (rootOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.MAP) {
            columnAttributes = ImmutableList.of((Object)new IcebergOrcColumn(0, rootOrcType.getFieldTypeIndex(0), Optional.empty(), "key", HiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(0))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(0))).getAttributes()), (Object)new IcebergOrcColumn(1, rootOrcType.getFieldTypeIndex(1), Optional.empty(), "value", HiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(1))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(1))).getAttributes()));
        } else if (rootOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.UNION) {
            columnAttributes = (List)IntStream.range(0, rootOrcType.getFieldCount()).mapToObj(fieldId -> new IcebergOrcColumn(fieldId, rootOrcType.getFieldTypeIndex(fieldId), Optional.empty(), "field" + fieldId, HiveColumnHandle.ColumnType.REGULAR, ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(fieldId))).getOrcTypeKind(), ((OrcType)orcTypes.get(rootOrcType.getFieldTypeIndex(fieldId))).getAttributes())).collect(ImmutableList.toImmutableList());
        }
        return columnAttributes;
    }

    private static /* synthetic */ HiveColumnHandle lambda$createBatchOrcPageSource$10(Map fileOrcColumnByIcebergId, Map fileOrcColumnsByName, IcebergColumnHandle column) {
        IcebergOrcColumn icebergOrcColumn;
        if (fileOrcColumnByIcebergId.isEmpty()) {
            icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnsByName.get(column.getName());
        } else {
            icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnByIcebergId.get(column.getId());
            if (icebergOrcColumn == null) {
                icebergOrcColumn = (IcebergOrcColumn)fileOrcColumnsByName.get(column.getName());
            }
        }
        return new HiveColumnHandle(column.getName(), TypeConverter.toHiveType(column.getType()), column.getType().getTypeSignature(), icebergOrcColumn != null ? icebergOrcColumn.getOrcColumnId() : column.getId() - 1, icebergOrcColumn != null ? icebergOrcColumn.getColumnType() : HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    }
}

