/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.iceberg.HdfsFileIO;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.UnknownTableTypeException;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.PrincipalType;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Tasks;

@NotThreadSafe
public class HiveTableOperations
implements TableOperations {
    private static final Logger log = Logger.get(HiveTableOperations.class);
    public static final String METADATA_LOCATION = "metadata_location";
    public static final String PREVIOUS_METADATA_LOCATION = "previous_metadata_location";
    private static final String METADATA_FOLDER_NAME = "metadata";
    private static final StorageFormat STORAGE_FORMAT = StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)FileInputFormat.class.getName(), (String)FileOutputFormat.class.getName());
    private final ExtendedHiveMetastore metastore;
    private final MetastoreContext metastoreContext;
    private final String database;
    private final String tableName;
    private final Optional<String> owner;
    private final Optional<String> location;
    private final FileIO fileIO;
    private TableMetadata currentMetadata;
    private String currentMetadataLocation;
    private boolean shouldRefresh = true;
    private int version = -1;
    private static LoadingCache<String, ReentrantLock> commitLockCache;

    public HiveTableOperations(ExtendedHiveMetastore metastore, MetastoreContext metastoreContext, HdfsEnvironment hdfsEnvironment, HdfsContext hdfsContext, String database, String table) {
        this(new HdfsFileIO(hdfsEnvironment, hdfsContext), metastore, metastoreContext, database, table, Optional.empty(), Optional.empty());
    }

    public HiveTableOperations(ExtendedHiveMetastore metastore, MetastoreContext metastoreContext, HdfsEnvironment hdfsEnvironment, HdfsContext hdfsContext, String database, String table, String owner, String location) {
        this(new HdfsFileIO(hdfsEnvironment, hdfsContext), metastore, metastoreContext, database, table, Optional.of(Objects.requireNonNull(owner, "owner is null")), Optional.of(Objects.requireNonNull(location, "location is null")));
    }

    private HiveTableOperations(FileIO fileIO, ExtendedHiveMetastore metastore, MetastoreContext metastoreContext, String database, String table, Optional<String> owner, Optional<String> location) {
        this.fileIO = Objects.requireNonNull(fileIO, "fileIO is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.metastoreContext = Objects.requireNonNull(metastoreContext, "metastore context is null");
        this.database = Objects.requireNonNull(database, "database is null");
        this.tableName = Objects.requireNonNull(table, "table is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.location = Objects.requireNonNull(location, "location is null");
        HiveTableOperations.initTableLevelLockCache(TimeUnit.MINUTES.toMillis(10L));
    }

    private static synchronized void initTableLevelLockCache(long evictionTimeout) {
        if (commitLockCache == null) {
            commitLockCache = CacheBuilder.newBuilder().expireAfterAccess(evictionTimeout, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, ReentrantLock>(){

                public ReentrantLock load(String fullName) {
                    return new ReentrantLock();
                }
            });
        }
    }

    public TableMetadata current() {
        if (this.shouldRefresh) {
            return this.refresh();
        }
        return this.currentMetadata;
    }

    public TableMetadata refresh() {
        if (this.location.isPresent()) {
            this.refreshFromMetadataLocation(null);
            return this.currentMetadata;
        }
        Table table = this.getTable();
        if (!IcebergUtil.isIcebergTable(table)) {
            throw new UnknownTableTypeException(this.getSchemaTableName());
        }
        String metadataLocation = (String)table.getParameters().get(METADATA_LOCATION);
        if (metadataLocation == null) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_METADATA, String.format("Table is missing [%s] property: %s", METADATA_LOCATION, this.getSchemaTableName()));
        }
        this.refreshFromMetadataLocation(metadataLocation);
        return this.currentMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(@Nullable TableMetadata base, TableMetadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        if (!Objects.equals(base, this.current())) {
            throw new CommitFailedException("Cannot commit: stale table metadata for %s", new Object[]{this.getSchemaTableName()});
        }
        if (Objects.equals(base, metadata)) {
            return;
        }
        String newMetadataLocation = this.writeNewMetadata(metadata, this.version + 1);
        Optional<Object> lockId = Optional.empty();
        ReentrantLock tableLevelMutex = (ReentrantLock)commitLockCache.getUnchecked((Object)(this.database + "." + this.tableName));
        tableLevelMutex.lock();
        try {
            Table table;
            try {
                lockId = Optional.of(this.metastore.lock(this.metastoreContext, this.database, this.tableName));
                if (base == null) {
                    String tableComment = (String)metadata.properties().get("comment");
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("EXTERNAL", "TRUE");
                    parameters.put("table_type", "iceberg");
                    parameters.put(METADATA_LOCATION, newMetadataLocation);
                    if (tableComment != null) {
                        parameters.put("comment", tableComment);
                    }
                    Table.Builder builder = Table.builder().setDatabaseName(this.database).setTableName(this.tableName).setOwner(this.owner.orElseThrow(() -> new IllegalStateException("Owner not set"))).setTableType(PrestoTableType.EXTERNAL_TABLE).setDataColumns(HiveTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).withStorage(storage -> storage.setStorageFormat(STORAGE_FORMAT)).setParameters(parameters);
                    table = builder.build();
                } else {
                    Table currentTable = this.getTable();
                    Preconditions.checkState((this.currentMetadataLocation != null ? 1 : 0) != 0, (Object)"No current metadata location for existing table");
                    String metadataLocation = (String)currentTable.getParameters().get(METADATA_LOCATION);
                    if (!this.currentMetadataLocation.equals(metadataLocation)) {
                        throw new CommitFailedException("Metadata location [%s] is not same as table metadata location [%s] for %s", new Object[]{this.currentMetadataLocation, metadataLocation, this.getSchemaTableName()});
                    }
                    table = Table.builder((Table)currentTable).setDataColumns(HiveTableOperations.toHiveColumns(metadata.schema().columns())).withStorage(storage -> storage.setLocation(metadata.location())).setParameter(METADATA_LOCATION, newMetadataLocation).setParameter(PREVIOUS_METADATA_LOCATION, this.currentMetadataLocation).build();
                }
            }
            catch (RuntimeException e) {
                try {
                    this.io().deleteFile(newMetadataLocation);
                }
                catch (RuntimeException exception) {
                    e.addSuppressed(exception);
                }
                throw e;
            }
            PrestoPrincipal owner = new PrestoPrincipal(PrincipalType.USER, table.getOwner());
            PrincipalPrivileges privileges = new PrincipalPrivileges((Multimap)ImmutableMultimap.builder().put((Object)table.getOwner(), (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, owner, owner)).put((Object)table.getOwner(), (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, true, owner, owner)).put((Object)table.getOwner(), (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, true, owner, owner)).put((Object)table.getOwner(), (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, true, owner, owner)).build(), (Multimap)ImmutableMultimap.of());
            if (base == null) {
                this.metastore.createTable(this.metastoreContext, table, privileges);
            } else {
                this.metastore.replaceTable(this.metastoreContext, this.database, this.tableName, table, privileges);
            }
            this.shouldRefresh = true;
        }
        catch (Throwable throwable) {
            this.shouldRefresh = true;
            try {
                lockId.ifPresent(id -> this.metastore.unlock(this.metastoreContext, id.longValue()));
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to unlock: %s", new Object[]{lockId.orElse(null)});
            }
            finally {
                tableLevelMutex.unlock();
            }
            throw throwable;
        }
        try {
            lockId.ifPresent(id -> this.metastore.unlock(this.metastoreContext, id.longValue()));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to unlock: %s", new Object[]{lockId.orElse(null)});
        }
        finally {
            tableLevelMutex.unlock();
        }
    }

    public FileIO io() {
        return this.fileIO;
    }

    public String metadataFileLocation(String filename) {
        String location;
        TableMetadata metadata = this.current();
        if (metadata != null) {
            String writeLocation = (String)metadata.properties().get("write.metadata.path");
            if (writeLocation != null) {
                return String.format("%s/%s", writeLocation, filename);
            }
            location = metadata.location();
        } else {
            location = this.location.orElseThrow(() -> new IllegalStateException("Location not set"));
        }
        return String.format("%s/%s/%s", location, METADATA_FOLDER_NAME, filename);
    }

    public LocationProvider locationProvider() {
        TableMetadata metadata = this.current();
        return LocationProviders.locationsFor((String)metadata.location(), (Map)metadata.properties());
    }

    private Table getTable() {
        return (Table)this.metastore.getTable(this.metastoreContext, this.database, this.tableName).orElseThrow(() -> new TableNotFoundException(this.getSchemaTableName()));
    }

    private SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.database, this.tableName);
    }

    private String writeNewMetadata(TableMetadata metadata, int newVersion) {
        String newTableMetadataFilePath = HiveTableOperations.newTableMetadataFilePath(metadata, newVersion);
        OutputFile newMetadataLocation = this.fileIO.newOutputFile(newTableMetadataFilePath);
        TableMetadataParser.write((TableMetadata)metadata, (OutputFile)newMetadataLocation);
        return newTableMetadataFilePath;
    }

    private void refreshFromMetadataLocation(String newLocation) {
        if (Objects.equals(this.currentMetadataLocation, newLocation)) {
            this.shouldRefresh = false;
            return;
        }
        AtomicReference newMetadata = new AtomicReference();
        Tasks.foreach((Object[])new String[]{newLocation}).retry(20).exponentialBackoff(100L, 5000L, 600000L, 4.0).suppressFailureWhenFinished().run(metadataLocation -> newMetadata.set(TableMetadataParser.read((TableOperations)this, (InputFile)this.io().newInputFile(metadataLocation))));
        if (newMetadata.get() == null) {
            throw new TableNotFoundException(this.getSchemaTableName(), "Table metadata is missing.");
        }
        String newUUID = ((TableMetadata)newMetadata.get()).uuid();
        if (this.currentMetadata != null) {
            Preconditions.checkState((newUUID == null || newUUID.equals(this.currentMetadata.uuid()) ? 1 : 0) != 0, (String)"Table UUID does not match: current=%s != refreshed=%s", (Object)this.currentMetadata.uuid(), (Object)newUUID);
        }
        this.currentMetadata = (TableMetadata)newMetadata.get();
        this.currentMetadataLocation = newLocation;
        this.version = HiveTableOperations.parseVersion(newLocation);
        this.shouldRefresh = false;
    }

    private static String newTableMetadataFilePath(TableMetadata meta, int newVersion) {
        String codec = meta.property("write.metadata.compression-codec", "none");
        return HiveTableOperations.metadataFileLocation(meta, String.format("%05d-%s%s", newVersion, UUID.randomUUID(), TableMetadataParser.getFileExtension((String)codec)));
    }

    private static String metadataFileLocation(TableMetadata metadata, String filename) {
        String location = (String)metadata.properties().get("write.metadata.path");
        if (location != null) {
            return String.format("%s/%s", location, filename);
        }
        return String.format("%s/%s/%s", metadata.location(), METADATA_FOLDER_NAME, filename);
    }

    private static int parseVersion(String metadataLocation) {
        int versionStart = metadataLocation.lastIndexOf(47) + 1;
        int versionEnd = metadataLocation.indexOf(45, versionStart);
        try {
            return Integer.parseInt(metadataLocation.substring(versionStart, versionEnd));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            log.warn((Throwable)e, "Unable to parse version from metadata location: %s", new Object[]{metadataLocation});
            return -1;
        }
    }

    private static List<Column> toHiveColumns(List<Types.NestedField> columns) {
        return (List)columns.stream().map(column -> new Column(column.name(), HiveType.toHiveType((TypeInfo)HiveSchemaUtil.convert((Type)column.type())), Optional.empty(), Optional.empty())).collect(ImmutableList.toImmutableList());
    }
}

