/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.iceberg.IcebergSplit;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.types.Type;

public class IcebergSplitSource
implements ConnectorSplitSource {
    private final CloseableIterable<CombinedScanTask> combinedScanIterable;
    private final Iterator<FileScanTask> fileScanIterator;

    public IcebergSplitSource(CloseableIterable<CombinedScanTask> combinedScanIterable) {
        this.combinedScanIterable = Objects.requireNonNull(combinedScanIterable, "combinedScanIterable is null");
        this.fileScanIterator = Streams.stream(combinedScanIterable).map(CombinedScanTask::files).flatMap(Collection::stream).iterator();
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        ArrayList<ConnectorSplit> splits = new ArrayList<ConnectorSplit>();
        Iterator iterator = Iterators.limit(this.fileScanIterator, (int)maxSize);
        while (iterator.hasNext()) {
            FileScanTask task = (FileScanTask)iterator.next();
            splits.add(this.toIcebergSplit(task));
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch(splits, this.isFinished()));
    }

    public boolean isFinished() {
        return !this.fileScanIterator.hasNext();
    }

    public void close() {
        try {
            this.combinedScanIterable.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ConnectorSplit toIcebergSplit(FileScanTask task) {
        return new IcebergSplit(task.file().path().toString(), task.start(), task.length(), task.file().format(), (List<HostAddress>)ImmutableList.of(), IcebergSplitSource.getPartitionKeys(task));
    }

    private static Map<Integer, String> getPartitionKeys(FileScanTask scanTask) {
        StructLike partition = scanTask.file().partition();
        PartitionSpec spec = scanTask.spec();
        Map<PartitionField, Integer> fieldToIndex = IcebergUtil.getIdentityPartitions(spec);
        HashMap partitionKeys = new HashMap();
        fieldToIndex.forEach((field, index) -> {
            int id = field.sourceId();
            Type type = spec.schema().findType(id);
            Class javaClass = type.typeId().javaClass();
            Object value = partition.get(index.intValue(), javaClass);
            if (value == null) {
                partitionKeys.put(id, null);
            } else {
                String partitionValue = type.typeId() == Type.TypeID.FIXED || type.typeId() == Type.TypeID.BINARY ? new String(((ByteBuffer)value).array(), StandardCharsets.UTF_8) : value.toString();
                partitionKeys.put(id, partitionValue);
            }
        });
        return Collections.unmodifiableMap(partitionKeys);
    }
}

