/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.iceberg.CommitTaskData;
import com.facebook.presto.iceberg.FilesTable;
import com.facebook.presto.iceberg.HistoryTable;
import com.facebook.presto.iceberg.IcebergColumnHandle;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergResourceFactory;
import com.facebook.presto.iceberg.IcebergTableHandle;
import com.facebook.presto.iceberg.IcebergTableLayoutHandle;
import com.facebook.presto.iceberg.IcebergTableName;
import com.facebook.presto.iceberg.IcebergTableProperties;
import com.facebook.presto.iceberg.IcebergUtil;
import com.facebook.presto.iceberg.IcebergWritableTableHandle;
import com.facebook.presto.iceberg.IcebergWrittenPartitions;
import com.facebook.presto.iceberg.ManifestsTable;
import com.facebook.presto.iceberg.PartitionData;
import com.facebook.presto.iceberg.PartitionFields;
import com.facebook.presto.iceberg.PartitionTable;
import com.facebook.presto.iceberg.SnapshotsTable;
import com.facebook.presto.iceberg.TableStatisticsMaker;
import com.facebook.presto.iceberg.TableType;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.iceberg.UnknownTableTypeException;
import com.facebook.presto.iceberg.util.IcebergPrestoModelConverters;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class IcebergNativeMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(IcebergNativeMetadata.class);
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final String TABLE_COMMENT = "comment";
    private final IcebergResourceFactory resourceFactory;
    private final TypeManager typeManager;
    private final JsonCodec<CommitTaskData> commitTaskCodec;
    private Transaction transaction;

    public IcebergNativeMetadata(IcebergResourceFactory resourceFactory, TypeManager typeManager, JsonCodec<CommitTaskData> commitTaskCodec) {
        this.resourceFactory = Objects.requireNonNull(resourceFactory, "resourceFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitTaskCodec = Objects.requireNonNull(commitTaskCodec, "commitTaskCodec is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        SupportsNamespaces supportsNamespaces = this.resourceFactory.getNamespaces(session);
        return supportsNamespaces.listNamespaces().stream().map(IcebergPrestoModelConverters::toPrestoSchemaName).collect(Collectors.toList());
    }

    public IcebergTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Table table;
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        Verify.verify((name.getTableType() == TableType.DATA ? 1 : 0) != 0, (String)("Wrong table type: " + (Object)((Object)name.getTableType())), (Object[])new Object[0]);
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(tableName.getSchemaName(), name.getTableName());
        try {
            table = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        }
        catch (NoSuchTableException e) {
            return null;
        }
        if (name.getSnapshotId().isPresent() && table.snapshot(name.getSnapshotId().get().longValue()) == null) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, String.format("Invalid snapshot [%s] for table: %s", name.getSnapshotId().get(), table));
        }
        return new IcebergTableHandle(tableName.getSchemaName(), name.getTableName(), name.getTableType(), Optional.of(name.getSnapshotId().orElse(table.currentSnapshot().snapshotId())), (TupleDomain<IcebergColumnHandle>)TupleDomain.all());
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        IcebergTableHandle handle = (IcebergTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new IcebergTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        Table table;
        IcebergTableName name = IcebergTableName.from(tableName.getTableName());
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(tableName.getSchemaName(), name.getTableName());
        try {
            table = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        }
        catch (NoSuchTableException e) {
            return Optional.empty();
        }
        if (name.getSnapshotId().isPresent() && table.snapshot(name.getSnapshotId().get().longValue()) == null) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_INVALID_SNAPSHOT_ID, String.format("Invalid snapshot [%s] for table: %s", name.getSnapshotId().get(), table));
        }
        SchemaTableName systemTableName = new SchemaTableName(tableName.getSchemaName(), name.getTableNameWithType());
        Optional<Long> snapshotId = Optional.of(name.getSnapshotId().orElse(table.currentSnapshot().snapshotId()));
        switch (name.getTableType()) {
            case HISTORY: {
                if (name.getSnapshotId().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snapshot ID not supported for history table: " + systemTableName);
                }
                return Optional.of(new HistoryTable(systemTableName, table));
            }
            case SNAPSHOTS: {
                if (name.getSnapshotId().isPresent()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Snapshot ID not supported for snapshots table: " + systemTableName);
                }
                return Optional.of(new SnapshotsTable(systemTableName, this.typeManager, table));
            }
            case PARTITIONS: {
                return Optional.of(new PartitionTable(systemTableName, this.typeManager, table, snapshotId));
            }
            case MANIFESTS: {
                return Optional.of(new ManifestsTable(systemTableName, table, snapshotId));
            }
            case FILES: {
                return Optional.of(new FilesTable(systemTableName, table, snapshotId, this.typeManager));
            }
        }
        return Optional.empty();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(session, ((IcebergTableHandle)table).getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && INFORMATION_SCHEMA.equals(schemaName.get())) {
            return this.listSchemaNames(session).stream().map(schema -> new SchemaTableName(INFORMATION_SCHEMA, schema)).collect(Collectors.toList());
        }
        return this.resourceFactory.getCatalog(session).listTables(IcebergPrestoModelConverters.toIcebergNamespace(schemaName)).stream().map(IcebergPrestoModelConverters::toPrestoSchemaTableName).collect(Collectors.toList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(table.getSchemaTableName()));
        return (Map)IcebergUtil.getColumns(icebergTable.schema(), this.typeManager).stream().collect(ImmutableMap.toImmutableMap(IcebergColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        IcebergColumnHandle column = (IcebergColumnHandle)columnHandle;
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setComment(column.getComment()).setHidden(false).build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        List<SchemaTableName> tables = prefix.getTableName() != null ? Collections.singletonList(prefix.toSchemaTableName()) : this.listTables(session, Optional.of(prefix.getSchemaName()));
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName table : tables) {
            try {
                columns.put((Object)table, (Object)this.getTableMetadata(session, table).getColumns());
            }
            catch (TableNotFoundException e) {
                log.warn(String.format("table disappeared during listing operation: %s", e.getMessage()));
            }
            catch (UnknownTableTypeException e) {
                log.warn(String.format("%s: Unknown table type of table %s", e.getMessage(), table.getTableName()));
            }
        }
        return columns.build();
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        this.resourceFactory.getNamespaces(session).createNamespace(IcebergPrestoModelConverters.toIcebergNamespace(Optional.of(schemaName)), properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString())));
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        try {
            this.resourceFactory.getNamespaces(session).dropNamespace(IcebergPrestoModelConverters.toIcebergNamespace(Optional.of(schemaName)));
        }
        catch (NamespaceNotEmptyException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Iceberg native catalog does not support rename namespace");
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Optional layout = this.getNewTableLayout(session, tableMetadata);
        this.finishCreateTable(session, this.beginCreateTable(session, tableMetadata, layout), (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Schema schema = IcebergNativeMetadata.toIcebergSchema(tableMetadata.getColumns());
        PartitionSpec partitionSpec = PartitionFields.parsePartitionFields(schema, IcebergTableProperties.getPartitioning(tableMetadata.getProperties()));
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builderWithExpectedSize((int)2);
        FileFormat fileFormat = IcebergTableProperties.getFileFormat(tableMetadata.getProperties());
        propertiesBuilder.put((Object)"write.format.default", (Object)fileFormat.toString());
        if (tableMetadata.getComment().isPresent()) {
            propertiesBuilder.put((Object)TABLE_COMMENT, tableMetadata.getComment().get());
        }
        try {
            this.transaction = this.resourceFactory.getCatalog(session).newCreateTableTransaction(IcebergPrestoModelConverters.toIcebergTableIdentifier(schemaTableName), schema, partitionSpec, (Map)propertiesBuilder.build());
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        Table icebergTable = this.transaction.table();
        return new IcebergWritableTableHandle(schemaName, tableName, SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), icebergTable.location(), fileFormat, icebergTable.properties());
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.finishInsert(session, (IcebergWritableTableHandle)tableHandle, fragments, computedStatistics);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        IcebergTableHandle table = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(table.getSchemaTableName()));
        this.transaction = icebergTable.newTransaction();
        return new IcebergWritableTableHandle(table.getSchemaName(), table.getTableName(), SchemaParser.toJson((Schema)icebergTable.schema()), PartitionSpecParser.toJson((PartitionSpec)icebergTable.spec()), IcebergUtil.getColumns(icebergTable.schema(), this.typeManager), icebergTable.location(), IcebergUtil.getFileFormat(icebergTable), icebergTable.properties());
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        IcebergWritableTableHandle table = (IcebergWritableTableHandle)insertHandle;
        Table icebergTable = this.transaction.table();
        List commitTasks = (List)fragments.stream().map(slice -> (CommitTaskData)this.commitTaskCodec.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
        Type[] partitionColumnTypes = (Type[])icebergTable.spec().fields().stream().map(field -> field.transform().getResultType(icebergTable.schema().findType(field.sourceId()))).toArray(Type[]::new);
        AppendFiles appendFiles = this.transaction.newFastAppend();
        FileIO io = this.transaction.table().io();
        for (CommitTaskData task : commitTasks) {
            DataFiles.Builder builder = DataFiles.builder((PartitionSpec)icebergTable.spec()).withInputFile(io.newInputFile(task.getPath())).withFormat(table.getFileFormat()).withMetrics(task.getMetrics().metrics());
            if (!icebergTable.spec().fields().isEmpty()) {
                String partitionDataJson = task.getPartitionDataJson().orElseThrow(() -> new VerifyException("No partition data for partitioned table"));
                builder.withPartition((StructLike)PartitionData.fromJson(partitionDataJson, partitionColumnTypes));
            }
            appendFiles.appendFile(builder.build());
        }
        appendFiles.commit();
        this.transaction.commitTransaction();
        return Optional.of(new IcebergWrittenPartitions((List)commitTasks.stream().map(CommitTaskData::getPath).collect(ImmutableList.toImmutableList())));
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new IcebergColumnHandle(0, "$row_id", (com.facebook.presto.common.type.Type)BigintType.BIGINT, Optional.empty());
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        this.resourceFactory.getCatalog(session).dropTable(tableIdentifier);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTable) {
        TableIdentifier from = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        TableIdentifier to = IcebergPrestoModelConverters.toIcebergTableIdentifier(newTable);
        this.resourceFactory.getCatalog(session).renameTable(from, to);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        icebergTable.updateSchema().addColumn(column.getName(), TypeConverter.toIcebergType(column.getType())).commit();
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        IcebergColumnHandle handle = (IcebergColumnHandle)column;
        icebergTable.updateSchema().deleteColumn(handle.getName()).commit();
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        TableIdentifier tableIdentifier = IcebergPrestoModelConverters.toIcebergTableIdentifier(((IcebergTableHandle)tableHandle).getSchemaTableName());
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(tableIdentifier);
        IcebergColumnHandle columnHandle = (IcebergColumnHandle)source;
        icebergTable.updateSchema().renameColumn(columnHandle.getName(), target).commit();
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName table) {
        Table icebergTable;
        try {
            icebergTable = this.resourceFactory.getCatalog(session).loadTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(table));
        }
        catch (NoSuchTableException e) {
            throw new TableNotFoundException(table);
        }
        List<ColumnMetadata> columns = this.getColumnMetadatas(icebergTable);
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"format", (Object)IcebergUtil.getFileFormat(icebergTable));
        if (!icebergTable.spec().fields().isEmpty()) {
            properties.put((Object)"partitioning", PartitionFields.toPartitionFields(icebergTable.spec()));
        }
        return new ConnectorTableMetadata(table, columns, (Map)properties.build(), IcebergUtil.getTableComment(icebergTable));
    }

    private List<ColumnMetadata> getColumnMetadatas(Table table) {
        return (List)table.schema().columns().stream().map(column -> ColumnMetadata.builder().setName(column.name()).setType(TypeConverter.toPrestoType(column.type(), this.typeManager)).setComment(Optional.ofNullable(column.doc())).setHidden(false).build()).collect(ImmutableList.toImmutableList());
    }

    private static Schema toIcebergSchema(List<ColumnMetadata> columns) {
        ArrayList<Types.NestedField> icebergColumns = new ArrayList<Types.NestedField>();
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            int index = icebergColumns.size();
            Type type = TypeConverter.toIcebergType(column.getType());
            Types.NestedField field = column.isNullable() ? Types.NestedField.optional((int)index, (String)column.getName(), (Type)type, (String)column.getComment()) : Types.NestedField.required((int)index, (String)column.getName(), (Type)type, (String)column.getComment());
            icebergColumns.add(field);
        }
        Types.StructType icebergSchema = Types.StructType.of(icebergColumns);
        AtomicInteger nextFieldId = new AtomicInteger(1);
        icebergSchema = TypeUtil.assignFreshIds((Type)icebergSchema, nextFieldId::getAndIncrement);
        return new Schema(icebergSchema.asStructType().fields());
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely");
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        IcebergTableHandle handle = (IcebergTableHandle)tableHandle;
        Table icebergTable = this.resourceFactory.getCatalog(session).loadTable(IcebergPrestoModelConverters.toIcebergTableIdentifier(handle.getSchemaTableName()));
        return TableStatisticsMaker.getTableStatistics(this.typeManager, constraint, handle, icebergTable);
    }
}

