/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.io.OutputStreamDataSink;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.orc.HdfsOrcDataSource;
import com.facebook.presto.iceberg.IcebergErrorCode;
import com.facebook.presto.iceberg.IcebergFileWriter;
import com.facebook.presto.iceberg.IcebergOrcFileWriter;
import com.facebook.presto.iceberg.IcebergParquetFileWriter;
import com.facebook.presto.iceberg.IcebergSessionProperties;
import com.facebook.presto.iceberg.TypeConverter;
import com.facebook.presto.iceberg.util.PrimitiveTypeMapBuilder;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcDataSourceId;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriterStats;
import com.facebook.presto.parquet.writer.ParquetWriterOptions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.joda.time.DateTimeZone;

public class IcebergFileWriterFactory {
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final FileFormatDataSourceStats readStats;
    private final NodeVersion nodeVersion;
    private final OrcWriterStats orcWriterStats = new OrcWriterStats();
    private final OrcFileWriterConfig orcFileWriterConfig;
    private final DwrfEncryptionProvider dwrfEncryptionProvider;

    @Inject
    public IcebergFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, FileFormatDataSourceStats readStats, NodeVersion nodeVersion, OrcFileWriterConfig orcFileWriterConfig, HiveDwrfEncryptionProvider dwrfEncryptionProvider) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.readStats = Objects.requireNonNull(readStats, "readStats is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.orcFileWriterConfig = Objects.requireNonNull(orcFileWriterConfig, "orcFileWriterConfig is null");
        this.dwrfEncryptionProvider = Objects.requireNonNull(dwrfEncryptionProvider, "DwrfEncryptionProvider is null").toDwrfEncryptionProvider();
    }

    public IcebergFileWriter createFileWriter(Path outputPath, Schema icebergSchema, JobConf jobConf, ConnectorSession session, HdfsContext hdfsContext, FileFormat fileFormat) {
        switch (fileFormat) {
            case PARQUET: {
                return this.createParquetWriter(outputPath, icebergSchema, jobConf, session, hdfsContext);
            }
            case ORC: {
                return this.createOrcWriter(outputPath, icebergSchema, jobConf, session);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "File format not supported for Iceberg: " + fileFormat);
    }

    private IcebergFileWriter createParquetWriter(Path outputPath, Schema icebergSchema, JobConf jobConf, ConnectorSession session, HdfsContext hdfsContext) {
        List fileColumnNames = (List)icebergSchema.columns().stream().map(Types.NestedField::name).collect(ImmutableList.toImmutableList());
        List fileColumnTypes = (List)icebergSchema.columns().stream().map(column -> TypeConverter.toPrestoType(column.type(), this.typeManager)).collect(ImmutableList.toImmutableList());
        try {
            ExtendedFileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), outputPath, (Configuration)jobConf);
            Callable<Void> rollbackAction = () -> IcebergFileWriterFactory.lambda$createParquetWriter$1((FileSystem)fileSystem, outputPath);
            ParquetWriterOptions parquetWriterOptions = ParquetWriterOptions.builder().setMaxPageSize(HiveSessionProperties.getParquetWriterPageSize((ConnectorSession)session)).setMaxPageSize(HiveSessionProperties.getParquetWriterBlockSize((ConnectorSession)session)).build();
            return new IcebergParquetFileWriter((OutputStream)this.hdfsEnvironment.doAs(session.getUser(), () -> IcebergFileWriterFactory.lambda$createParquetWriter$2((FileSystem)fileSystem, outputPath)), rollbackAction, fileColumnNames, fileColumnTypes, ParquetSchemaUtil.convert((Schema)icebergSchema, (String)"table"), PrimitiveTypeMapBuilder.makeTypeMap(fileColumnTypes, fileColumnNames), parquetWriterOptions, IntStream.range(0, fileColumnNames.size()).toArray(), (CompressionCodecName)IcebergSessionProperties.getCompressionCodec(session).getParquetCompressionCodec().get(), outputPath, this.hdfsEnvironment, hdfsContext);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_OPEN_ERROR, "Error creating Parquet file", (Throwable)e);
        }
    }

    private IcebergFileWriter createOrcWriter(Path outputPath, Schema icebergSchema, JobConf jobConf, ConnectorSession session) {
        try {
            ExtendedFileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), outputPath, (Configuration)jobConf);
            DataSink orcDataSink = (DataSink)this.hdfsEnvironment.doAs(session.getUser(), () -> IcebergFileWriterFactory.lambda$createOrcWriter$3((FileSystem)fileSystem, outputPath));
            Callable<Void> rollbackAction = () -> this.lambda$createOrcWriter$5(session, (FileSystem)fileSystem, outputPath);
            List columnFields = icebergSchema.columns();
            List fileColumnNames = (List)columnFields.stream().map(Types.NestedField::name).collect(ImmutableList.toImmutableList());
            List fileColumnTypes = (List)columnFields.stream().map(Types.NestedField::type).map(type -> TypeConverter.toPrestoType(type, this.typeManager)).collect(ImmutableList.toImmutableList());
            Optional<Supplier<OrcDataSource>> validationInputFactory = Optional.empty();
            if (IcebergSessionProperties.isOrcOptimizedWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> this.lambda$createOrcWriter$9(outputPath, session, (FileSystem)fileSystem));
            }
            return new IcebergOrcFileWriter(icebergSchema, orcDataSink, rollbackAction, OrcEncoding.ORC, fileColumnNames, fileColumnTypes, TypeConverter.toOrcType(icebergSchema), IcebergSessionProperties.getCompressionCodec(session).getOrcCompressionKind(), this.orcFileWriterConfig.toOrcWriterOptionsBuilder().withStripeMinSize(HiveSessionProperties.getOrcOptimizedWriterMinStripeSize((ConnectorSession)session)).withStripeMaxSize(HiveSessionProperties.getOrcOptimizedWriterMaxStripeSize((ConnectorSession)session)).withStripeMaxRowCount(HiveSessionProperties.getOrcOptimizedWriterMaxStripeRows((ConnectorSession)session)).withDictionaryMaxMemory(HiveSessionProperties.getOrcOptimizedWriterMaxDictionaryMemory((ConnectorSession)session)).withMaxStringStatisticsLimit(HiveSessionProperties.getOrcStringStatisticsLimit((ConnectorSession)session)).build(), IntStream.range(0, fileColumnNames.size()).toArray(), (Map<String, String>)ImmutableMap.builder().put((Object)"presto_version", (Object)this.nodeVersion.toString()).put((Object)"presto_query_id", (Object)session.getQueryId()).build(), DateTimeZone.UTC, validationInputFactory, IcebergSessionProperties.getOrcOptimizedWriterValidateMode(session), this.orcWriterStats, this.dwrfEncryptionProvider, Optional.empty());
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITER_OPEN_ERROR, "Error creating ORC file", (Throwable)e);
        }
    }

    private /* synthetic */ OrcDataSource lambda$createOrcWriter$9(Path outputPath, ConnectorSession session, FileSystem fileSystem) {
        try {
            return new HdfsOrcDataSource(new OrcDataSourceId(outputPath.toString()), ((Long)this.hdfsEnvironment.doAs(session.getUser(), () -> fileSystem.getFileStatus(outputPath).getLen())).longValue(), IcebergSessionProperties.getOrcMaxMergeDistance(session), IcebergSessionProperties.getOrcMaxBufferSize(session), IcebergSessionProperties.getOrcStreamBufferSize(session), false, (FSDataInputStream)this.hdfsEnvironment.doAs(session.getUser(), () -> fileSystem.open(outputPath)), this.readStats);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)IcebergErrorCode.ICEBERG_WRITE_VALIDATION_FAILED, (Throwable)e);
        }
    }

    private /* synthetic */ Void lambda$createOrcWriter$5(ConnectorSession session, FileSystem fileSystem, Path outputPath) throws Exception {
        this.hdfsEnvironment.doAs(session.getUser(), () -> fileSystem.delete(outputPath, false));
        return null;
    }

    private static /* synthetic */ OutputStreamDataSink lambda$createOrcWriter$3(FileSystem fileSystem, Path outputPath) throws IOException {
        return new OutputStreamDataSink((OutputStream)fileSystem.create(outputPath));
    }

    private static /* synthetic */ FSDataOutputStream lambda$createParquetWriter$2(FileSystem fileSystem, Path outputPath) throws IOException {
        return fileSystem.create(outputPath);
    }

    private static /* synthetic */ Void lambda$createParquetWriter$1(FileSystem fileSystem, Path outputPath) throws Exception {
        fileSystem.delete(outputPath, false);
        return null;
    }
}

