/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.iceberg;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.iceberg.CatalogType;
import com.facebook.presto.iceberg.IcebergFileFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.iceberg.FileFormat;

public class IcebergConfig {
    private IcebergFileFormat fileFormat = IcebergFileFormat.PARQUET;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.GZIP;
    private boolean nativeMode;
    private CatalogType catalogType = CatalogType.HADOOP;
    private String catalogWarehouse;
    private String catalogUri;
    private int catalogCacheSize = 10;
    private List<String> hadoopConfigResources = ImmutableList.of();

    @NotNull
    public FileFormat getFileFormat() {
        return FileFormat.valueOf((String)this.fileFormat.name());
    }

    @Config(value="iceberg.file-format")
    public IcebergConfig setFileFormat(IcebergFileFormat fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @NotNull
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="iceberg.compression-codec")
    public IcebergConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    public boolean isNativeMode() {
        return this.nativeMode;
    }

    @Config(value="iceberg.native-mode")
    @ConfigDescription(value="if use Iceberg connector native catalog mode")
    public IcebergConfig setNativeMode(boolean nativeMode) {
        this.nativeMode = nativeMode;
        return this;
    }

    @NotNull
    public CatalogType getCatalogType() {
        return this.catalogType;
    }

    @Config(value="iceberg.catalog.type")
    @ConfigDescription(value="Iceberg catalog type")
    public IcebergConfig setCatalogType(CatalogType catalogType) {
        this.catalogType = catalogType;
        return this;
    }

    public String getCatalogWarehouse() {
        return this.catalogWarehouse;
    }

    @Config(value="iceberg.catalog.warehouse")
    @ConfigDescription(value="Iceberg catalog warehouse root path")
    public IcebergConfig setCatalogWarehouse(String catalogWarehouse) {
        this.catalogWarehouse = catalogWarehouse;
        return this;
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    @Config(value="iceberg.catalog.uri")
    @ConfigDescription(value="Iceberg catalog connection URI")
    public IcebergConfig setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getCatalogCacheSize() {
        return this.catalogCacheSize;
    }

    @Config(value="iceberg.catalog.cached-catalog-num")
    @ConfigDescription(value="number of Iceberg catalog to cache across all sessions")
    public IcebergConfig setCatalogCacheSize(int catalogCacheSize) {
        this.catalogCacheSize = catalogCacheSize;
        return this;
    }

    public List<String> getHadoopConfigResources() {
        return this.hadoopConfigResources;
    }

    @Config(value="iceberg.hadoop.config.resources")
    @ConfigDescription(value="Comma separated paths to Hadoop configuration resource files")
    public IcebergConfig setHadoopConfigResources(String files) {
        if (files != null) {
            this.hadoopConfigResources = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        }
        return this;
    }
}

