/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.function.SqlFunctionResult;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.hive.functions.ForHiveFunction;
import com.facebook.presto.hive.functions.FunctionRegistry;
import com.facebook.presto.hive.functions.HiveFunction;
import com.facebook.presto.hive.functions.HiveFunctionErrorCode;
import com.facebook.presto.hive.functions.HiveFunctionHandle;
import com.facebook.presto.hive.functions.HiveFunctionRegistry;
import com.facebook.presto.hive.functions.aggregation.HiveAggregationFunction;
import com.facebook.presto.hive.functions.scalar.HiveScalarFunction;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.function.AggregationFunctionImplementation;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionNamespaceManager;
import com.facebook.presto.spi.function.FunctionNamespaceTransactionHandle;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;

public class HiveFunctionNamespaceManager
implements FunctionNamespaceManager<HiveFunction> {
    public static final String ID = "hive-functions";
    private final String catalogName;
    private final ClassLoader classLoader;
    private final LoadingCache<FunctionKey, HiveFunction> functions;
    private final HiveFunctionRegistry hiveFunctionRegistry;
    private final TypeManager typeManager;

    @Inject
    public HiveFunctionNamespaceManager(@ForHiveFunction String catalogName, @ForHiveFunction ClassLoader classLoader, HiveFunctionRegistry hiveFunctionRegistry, TypeManager typeManager) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.hiveFunctionRegistry = Objects.requireNonNull(hiveFunctionRegistry, "hiveFunctionRegistry is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functions = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(this::initializeFunction));
    }

    public void setBlockEncodingSerde(BlockEncodingSerde blockEncodingSerde) {
    }

    public FunctionNamespaceTransactionHandle beginTransaction() {
        return new EmptyTransactionHandle();
    }

    public void commit(FunctionNamespaceTransactionHandle transactionHandle) {
    }

    public void abort(FunctionNamespaceTransactionHandle transactionHandle) {
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        throw new IllegalStateException(String.format("Cannot create function in hive function namespace: %s", function.getSignature().getName()));
    }

    public void alterFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        throw new IllegalStateException(String.format("Cannot alter function in hive function namespace: %s", functionName));
    }

    public void dropFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        throw new IllegalStateException(String.format("Cannot drop function in hive function namespace: %s", functionName));
    }

    public Collection<HiveFunction> listFunctions(Optional<String> likePattern, Optional<String> escape) {
        return (Collection)FunctionRegistry.getCurrentFunctionNames().stream().map(functionName -> this.createDummyHiveFunction((String)functionName)).collect(ImmutableList.toImmutableList());
    }

    public Collection<HiveFunction> getFunctions(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, QualifiedObjectName functionName) {
        throw new IllegalStateException("Get function is not supported");
    }

    public FunctionHandle getFunctionHandle(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, Signature signature) {
        throw new IllegalStateException("Get function handle is not supported");
    }

    public FunctionHandle resolveFunction(Optional<? extends FunctionNamespaceTransactionHandle> transactionHandle, QualifiedObjectName functionName, List<TypeSignature> parameterTypes) {
        return new HiveFunctionHandle(this.initializeFunction(FunctionKey.of(functionName, parameterTypes)).getSignature());
    }

    public FunctionMetadata getFunctionMetadata(FunctionHandle functionHandle) {
        Preconditions.checkArgument((boolean)(functionHandle instanceof HiveFunctionHandle));
        HiveFunction function = (HiveFunction)this.functions.getUnchecked((Object)FunctionKey.from((HiveFunctionHandle)functionHandle));
        return function.getFunctionMetadata();
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        Preconditions.checkArgument((boolean)(functionHandle instanceof HiveFunctionHandle));
        HiveFunction function = (HiveFunction)this.functions.getUnchecked((Object)FunctionKey.from((HiveFunctionHandle)functionHandle));
        Preconditions.checkState((boolean)(function instanceof HiveScalarFunction));
        return ((HiveScalarFunction)function).getJavaScalarFunctionImplementation();
    }

    public CompletableFuture<SqlFunctionResult> executeFunction(String source, FunctionHandle functionHandle, Page input, List<Integer> channels, TypeManager typeManager) {
        throw new IllegalStateException("Execute function is not supported");
    }

    public void addUserDefinedType(UserDefinedType userDefinedType) {
        throw new IllegalStateException("User defined type is not supported");
    }

    public Optional<UserDefinedType> getUserDefinedType(QualifiedObjectName typeName) {
        throw new IllegalStateException("User defined type is not supported");
    }

    public boolean canResolveFunction() {
        return true;
    }

    private HiveFunction initializeFunction(FunctionKey key) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class<?> functionClass;
            QualifiedObjectName name;
            block11: {
                name = key.getName();
                try {
                    functionClass = this.hiveFunctionRegistry.getClass(name);
                    if (!HiveFunctionNamespaceManager.anyAssignableFrom(functionClass, GenericUDF.class, UDF.class)) break block11;
                    HiveScalarFunction hiveScalarFunction = HiveScalarFunction.createHiveScalarFunction(functionClass, name, key.getArgumentTypes(), this.typeManager);
                    return hiveScalarFunction;
                }
                catch (ClassNotFoundException e) {
                    throw HiveFunctionErrorCode.functionNotFound(name.toString());
                }
            }
            if (HiveFunctionNamespaceManager.anyAssignableFrom(GenericUDAFResolver2.class, GenericUDAFResolver.class, UDAF.class)) {
                HiveAggregationFunction hiveAggregationFunction = HiveAggregationFunction.createHiveAggregateFunction(functionClass, name, key.getArgumentTypes(), this.typeManager);
                return hiveAggregationFunction;
            }
            throw HiveFunctionErrorCode.unsupportedFunctionType(functionClass);
        }
    }

    private HiveFunction createDummyHiveFunction(String functionName) {
        QualifiedObjectName hiveFunctionName = QualifiedObjectName.valueOf((String)this.catalogName, (String)"default", (String)functionName);
        Signature signature = new Signature(hiveFunctionName, FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"T"), new TypeSignature[0]);
        return new DummyHiveFunction(signature);
    }

    private static boolean anyAssignableFrom(Class<?> cls, Class<?> ... supers) {
        return Stream.of(supers).anyMatch(s -> s.isAssignableFrom(cls));
    }

    public AggregationFunctionImplementation getAggregateFunctionImplementation(FunctionHandle functionHandle, TypeManager typeManager) {
        Preconditions.checkArgument((boolean)(functionHandle instanceof HiveFunctionHandle));
        HiveFunction function = (HiveFunction)this.functions.getUnchecked((Object)FunctionKey.from((HiveFunctionHandle)functionHandle));
        Verify.verify((boolean)(function instanceof HiveAggregationFunction));
        return ((HiveAggregationFunction)function).getImplementation();
    }

    private static class EmptyTransactionHandle
    implements FunctionNamespaceTransactionHandle {
        private EmptyTransactionHandle() {
        }
    }

    private static class FunctionKey {
        private final QualifiedObjectName name;
        private final List<TypeSignature> argumentTypes;

        public static FunctionKey from(HiveFunctionHandle handle) {
            Signature signature = handle.getSignature();
            return FunctionKey.of(signature.getName(), signature.getArgumentTypes());
        }

        private static FunctionKey of(QualifiedObjectName name, List<TypeSignature> argumentTypes) {
            return new FunctionKey(name, argumentTypes);
        }

        private FunctionKey(QualifiedObjectName name, List<TypeSignature> argumentTypes) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        }

        public QualifiedObjectName getName() {
            return this.name;
        }

        public List<TypeSignature> getArgumentTypes() {
            return this.argumentTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argumentTypes);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("arguments", this.argumentTypes).toString();
        }
    }

    private static class DummyHiveFunction
    extends HiveFunction {
        public DummyHiveFunction(Signature signature) {
            super(signature.getName(), signature, false, true, true, "");
        }

        @Override
        public FunctionMetadata getFunctionMetadata() {
            throw new IllegalStateException("Get function metadata is not supported");
        }

        public SqlFunctionVisibility getVisibility() {
            return SqlFunctionVisibility.PUBLIC;
        }
    }
}

